<?php

namespace App\Service\Dashboard;



class Township extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\Township);
    }

    public function save($data)
    {
        return $this->model->create([
            "name" => $data["name"],
            "short_code" => $data["short_code"],
            "initial" => $data["initial"],
            "township_group_id" => $data["township_group_id"],
            "region_id" => $data["region_id"],
            "both_mdr_picts" => $data["both_mdr_picts"],
        ]);
    }


    public function withColumn()
    {
        $this->model = $this->model->with([
            "township_group", "region"
        ]);
    }

    public function getEach($column = null, $value = null)
    {
        $this->withColumn();
        return $this->model->where($column, $value)->first();
    }


    public function getAll($data)
    {
        $this->withColumn();
        $this->filter(["name", "region_id", "township_group_id"], $data);
        return $this->model->where("status", 1)->get();
    }

    public function update($data)
    {
        $model = $this->getEach("id", $data["id"]);
        $model->update([
            "name" => $data["name"],
            "short_code" => $data["short_code"],
            "initial" => $data["initial"],
            "township_group_id" => $data["township_group_id"],
            "region_id" => $data["region_id"],
            "both_mdr_picts" => $data["both_mdr_picts"],
        ]);
        return $model;
    }

    public function delete($id)
    {
        $model = $this->getEach("id", $id);
        $model->status = 0;
        $model->update();
        return true;
    }
}
