<?php

namespace App\Service\Dashboard;
class Sympton extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\Sympton);
    }

    public function save($data)
    {
        return $this->model->create([
            "name" => $data["name"],
            "mm_name" => $data["mm_name"],
        ]);
    }


    public function getAll($data)
    {
        $this->filter(["name"], $data);
        return $this->model->where("status", 1)->get();
    }

    public function update($data)
    {
        $model = $this->getEach("id", $data["id"]);
        $model->update([
            "name" => $data["name"],
            "mm_name" => $data["mm_name"],
        ]);
        return $model;
    }

    public function delete($id)
    {
        $model = $this->getEach("id", $id);
        $model->status = 0;
        $model->update();
        return true;
    }
}
