<?php

namespace App\Service\Dashboard;

class SupervisionVisit extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\SupervisionVisitActivity());
    }

    public function withColumn()
    {
        $this->model = $this->model->with([
            "patient", "volunteer",
             "township" => function ($query) {
                $query->with([
                    "township_group" ]);
            },
        ]);
        
        $this->model=$this->model->whereHas("township",function($query){
                            $query->whereIn('township_group_id', [1, 2]);    
                        });
                        
    }

    public function getEach($column = null, $value = null)
    {
        $this->withColumn();
        return $this->model->where($column, $value)->first();
    }


    public function getAll($data)
    {
        $month=(int)$data['month'];
        
        if($month<13)
        {
            $this->withColumn();
            $this->filter(["month", "year", "id", "township_id"], $data);
        }
        if($month==13)
        {
             $this->withColumn();
             $this->filter(["year", "id"], $data);
             $this->model->whereBetween('month',[1,3]);
        }
        if($month==14)
        {
             $this->withColumn();
             $this->filter(["year", "id"], $data);
             $this->model->whereBetween('month',[4,6]);
        }
        if($month==15)
        {
             $this->withColumn();
             $this->filter(["year", "id"], $data);
             $this->model->whereBetween('month',[7,9]);
        }
        if($month==16)
        {
             $this->withColumn();
             $this->filter(["year", "id"], $data);
             $this->model->whereBetween('month',[10,12]);
        }
        if($month==17)
        {
             $this->withColumn();
             $this->filter(["year", "id"], $data);
             $this->model->whereBetween('month',[1,6]);
        }
        if($month==18)
        {
             $this->withColumn();
             $this->filter(["year", "id"], $data);
             $this->model->whereBetween('month',[7,12]);
        }
        if($month==19)
        {
             $this->withColumn();
             $this->filter(["year", "id"], $data);
             $this->model->whereBetween('month',[1,12]);
        }
        
        return $this->model->get();
    }
}
