<?php

namespace App\Service\Dashboard;

class ReferPatient extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\Presumptive());
    }


    public function getEach($column = null, $value = null)
    {
        $this->withColumn();
        return $this->model->where($column, $value)->first();
    }

    public function withColumn()
    {
        $this->model = $this->model->with([
            "volunteer", "township", "case_found_at_name"
        ]);
    }


    public function getAll($data)
    {
        $this->withColumn();
        $this->filter(["patient_id", "volunteer_id","township_id"], $data);
        if (request("township_group_id")) {
            $this->model = $this->model->whereHas("township", function ($query) {
                $query->where("township_group_id", request("township_group_id"));
            });
        }

        if (request("region_id")) {
            $this->model = $this->model->whereHas("township", function ($query) {
                $query->where("region_id", request("region_id"));
            });
        }
        return $this->model->where("status", 1)->where("volunteer_id", "!=", NULL)->get();
    }
}
