<?php

namespace App\Service\Dashboard;



class PA extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\PA);
    }

    public function save($data)
    {
        $lastSerial = \App\Models\PA::where("township_id", $data["township_id"])->orderBy("serial", "desc")->first();
        
        if(!isset($lastSerial))
        {
            $serial=1;
        }else{
            $serial = $lastSerial->serial + 1;
        }

        return $this->model->create([
            "name" => $data["name"],
            "township_id" => $data["township_id"],
            "serial" => $serial,
            "code" => $this->getPACode($data["township_id"], $serial),
            "password" => rand(10000, 99999)
        ]);
    }

    public function withColumn()
    {
        $this->model = $this->model->with([
            "township",
        ]);
    }

    public function getEach($column = null, $value = null)
    {
        $this->withColumn();
        return $this->model->where($column, $value)->first();
    }

    public function getPACode($township_id, $serial)
    {
        $code = "FO";
        $township = \App\Models\Township::where("id", $township_id)->first();
        $code = $code . $township->short_code;


        if ($serial < 10) {
            $serial = "00" . $serial;
        } else if ($serial < 100) {
            $serial = "0" . $serial;
        }
        $code = $code . $serial;
        return $code;
    }


    public function getAll($data)
    {
        $this->withColumn();
        $this->filter(["name", "township_id"], $data);
        return $this->model->where("status", 1)->get();
    }

    public function update($data)
    {
        $model = $this->getEach("id", $data["id"]);
        $model->update([
            "name" => $data["name"],
            "township_id" => $data["township_id"],
        ]);
        return $model;
    }

    public function delete($id)
    {
        $model = $this->getEach("id", $id);
        $model->status = 0;
        $model->update();
        return true;
    }
}
