<?php

namespace App\Service\Dashboard;

use \Datetime;

class Nomination
{
    
     public function get()
    {
         $enrolls=\App\Models\EnrollSupport::where('nominated_month', request("month"))
                                            ->where('nominated_year', request("year"))
                                            ->where('nominated',2)
                                            ->where('support',2)
                                            ->whereHas('patient', function($q)
                                            {
                                                $q->where("township_id", request("township_id"))
                                                    ->where("status", 1);
                                            })->groupBy('patient_id')->with(["patient" => function ($query) {
                                                $query->orderBy("treatment_startdate", "asc");
                                            }]);
        $enrolls= $enrolls->get();
   
        $data = [];
        
        foreach ($enrolls as $enroll) {
            $patient=$enroll->patient;
            if (!$patient["finished_date"]) {
                $patient["treatment_status"] = "On-going";
            } else {
                $month = date("m", strtotime($patient["finished_date"]));
                $year = date("Y", strtotime($patient["finished_date"]));
                if (request()->year < $year) {
                    $patient["treatment_status"] = "On-going";
                } else {
                    if (request()->year > $year) $patient["treatment_status"] = $this->getFinishStatus($patient["treatment_finish"]);
                    else {
                        if (request()->month < $month)  $patient["treatment_status"] = "On-going";
                        else $patient["treatment_status"] = $this->getFinishStatus($patient["treatment_finish"]);
                    }
                }
            }


            array_push($data, [
                "name" => $patient["name"],
                "dob" => $patient["dob"],
                "sex" => $patient["sex"],
                "code" => $patient["mdrtb_reg_no"],
                "year" => $patient["mdrtb_reg_year"],
                "drtb_code"=>$patient["mdrtb_reg_no"] .'/'.$patient["mdrtb_reg_year"],
                "monopoly" => $patient["mdrtb_monopoly"],
                "reg_unique_code" => $patient["reg_unique_code"],
                "treatment_startdate" => $patient["treatment_startdate"],
                "treatment_status" => $patient["treatment_status"],
                "finished_date" => $patient["finished_date"],
                "current_month" => $this->getHowManMonth($patient["treatment_startdate"]) + 1,
                "support_month" => $enroll->support_month,
                "last_enrolls" => \App\Models\EnrollSupport::where("patient_id", $patient["id"])
                                ->where('nominated_month', request("month"))
                                ->where('nominated_year', request("year"))
                                ->where("support", 2)->orderBy("id", "desc")->get()
            ]);
        }
        
        return $data;
        
        $patients = \App\Models\Patient::where("township_id", request("township_id"))->where("status", 1)
            ->where(function ($query) {
                $query->whereYear("treatment_startdate", "<", request("year"))->orWhere(function ($query) {
                    $query->whereMonth("treatment_startdate", "<=", request("month"))->whereYear("treatment_startdate", "<=", request("year"));
                });
            })->where(function ($query) {
                $query->whereYear("finished_date", ">", request("year"))->orWhere(function ($query) {
                    $query->whereMonth("finished_date", ">=", request("month"))->whereYear("finished_date", ">=", request("year"));
                });
            });
        $patients = $patients->get()->toArray();

        $data = [];
        foreach ($patients as $patient) {

            if (!$patient["finished_date"]) {
                $patient["treatment_status"] = "On-going";
            } else {
                $month = date("m", strtotime($patient["finished_date"]));
                $year = date("Y", strtotime($patient["finished_date"]));
                if (request()->year < $year) {
                    $patient["treatment_status"] = "On-going";
                } else {
                    if (request()->year > $year) $patient["treatment_status"] = $this->getFinishStatus($patient["treatment_finish"]);
                    else {
                        if (request()->month < $month)  $patient["treatment_status"] = "On-going";
                        else $patient["treatment_status"] = $this->getFinishStatus($patient["treatment_finish"]);
                    }
                }
            }


            array_push($data, [
                "name" => $patient["name"],
                "dob" => $patient["dob"],
                "sex" => $patient["sex"],
                "reg_unique_code" => $patient["reg_unique_code"],
                 "code" => $patient["mdrtb_reg_no"],
                "year" => $patient["mdrtb_reg_year"],
                "treatment_startdate" => $patient["treatment_startdate"],
                "treatment_status" => $patient["treatment_status"],
                "finished_date" => $patient["finished_date"],
                "current_month" => $this->getHowManMonth($patient["treatment_startdate"]) + 1,
                "support_month" => $enroll->support_month,
                "last_enrolls" => \App\Models\EnrollSupport::where("patient_id", $patient["id"])->where("support", 2)->orderBy("id", "desc")->get()
            ]);
        }

        return $data;
    }

    public function get14A()
    {
         $enrolls=\App\Models\PreEnrollSupport::where('nominated_month', request("month"))
                    ->where('nominated_year', request("year"))
                    ->where('nominated',2)
                    ->where('support',2)
                    ->whereHas('patient', function($q)
                    {
                        $q->where("township_id", request("township_id"))
                            ->where("status", 1);
                    })->groupBy('patient_id')->with(["patient" => function ($query) {
                        $query->orderBy("treatment_startdate", "asc");
                    }]);
        $enrolls= $enrolls->get();
   
        $data = [];
        
        foreach ($enrolls as $enroll) {
            $patient=$enroll->patient;
            if (!$patient["finished_date"]) {
                $patient["treatment_status"] = "On-going";
            } else {
                $month = date("m", strtotime($patient["finished_date"]));
                $year = date("Y", strtotime($patient["finished_date"]));
                if (request()->year < $year) {
                    $patient["treatment_status"] = "On-going";
                } else {
                    if (request()->year > $year) $patient["treatment_status"] = $this->getFinishStatus($patient["treatment_finish"]);
                    else {
                        if (request()->month < $month)  $patient["treatment_status"] = "On-going";
                        else $patient["treatment_status"] = $this->getFinishStatus($patient["treatment_finish"]);
                    }
                }
            }


            array_push($data, [
                "name" => $patient["name"],
                "dob" => $patient["dob"],
                "sex" => $patient["sex"],
                "lab_code"=>$patient['xpert_mtb_code'],
                "lab_date"=>$patient['xpert_mtb_date'],
                "treatment_status" => $patient["treatment_status"],
                "finished_date" => $patient["finished_date"],
                "current_month" => $this->getHowManMonth($patient["treatment_startdate"]) + 1,
                "support_month" => $enroll->month_type,
                "preenroll_month_types" => \App\Models\PreEnrollSupport::where("patient_id", $patient["id"])
                                ->where('nominated_month', request("month"))
                                ->where('nominated_year', request("year"))
                                ->where("support", 2)->orderBy("id", "asc")->get(),
                
            ]);
        }
        
        return $data;
    }
    
     // public function get()
    // {
    //       $enrolls=\App\Models\EnrollSupport::where('nominated_month', request("month"))
    //                                         ->where('nominated_year', request("year"))
    //                                         ->where('nominated',2)
    //                                         ->where('support',2)
    //                                         ->whereHas('patient', function($q)
    //                                         {
    //                                             $q->where("township_id", request("township_id"))
    //                                                 ->where("status", 1);
    //                                         })->groupBy('patient_id')->with(["patient" => function ($query) {
    //                                             $query->orderBy("treatment_startdate", "asc");
    //                                         }]);
    //     $enrolls= $enrolls->get();
        
    //      $data = [];
        
    //     foreach ($enrolls as $enroll) {
    //         $patient=$enroll->patient;
    //         if (!$patient["finished_date"]) {
    //             $patient["treatment_status"] = "On-going";
    //         } else {
    //             $month = date("m", strtotime($patient["finished_date"]));
    //             $year = date("Y", strtotime($patient["finished_date"]));
    //             if (request()->year < $year) {
    //                 $patient["treatment_status"] = "On-going";
    //             } else {
    //                 if (request()->year > $year) $patient["treatment_status"] = $this->getFinishStatus($patient["treatment_finish"]);
    //                 else {
    //                     if (request()->month < $month)  $patient["treatment_status"] = "On-going";
    //                     else $patient["treatment_status"] = $this->getFinishStatus($patient["treatment_finish"]);
    //                 }
    //             }
    //         }
            
    //           array_push($data, [
    //             "name" => $patient["name"],
    //             "dob" => $patient["dob"],
    //             "sex" => $patient["sex"],
    //             "code" => $patient["mdrtb_reg_no"],
    //             "year" => $patient["mdrtb_reg_year"],
    //             "monopoly" => $patient["mdrtb_monopoly"],
    //             "reg_unique_code" => $patient["reg_unique_code"],
    //             "treatment_startdate" => $patient["treatment_startdate"],
    //             "treatment_status" => $patient["treatment_status"],
    //             "finished_date" => $patient["finished_date"],
    //             "current_month" => $this->getHowManMonth($patient["treatment_startdate"]) + 1,
    //             "support_month" => $enroll->support_month,
    //             "last_enrolls" => \App\Models\EnrollSupport::where("patient_id", $patient["id"])
    //                             ->where('nominated_month', request("month"))
    //                             ->where('nominated_year', request("year"))
    //                             ->where("support", 2)->orderBy("id", "desc")->get()
    //         ]);
    //     }
        
    //     return $data;
        
    //     $patients = \App\Models\Patient::where("township_id", request("township_id"))->where("status", 1)
    //         ->where(function ($query) {
    //             $query->whereYear("treatment_startdate", "<", request("year"))->orWhere(function ($query) {
    //                 $query->whereMonth("treatment_startdate", "<=", request("month"))->whereYear("treatment_startdate", "<=", request("year"));
    //             });
    //         })->where(function ($query) {
    //             $query->whereYear("finished_date", ">", request("year"))->orWhere(function ($query) {
    //                 $query->whereMonth("finished_date", ">=", request("month"))->whereYear("finished_date", ">=", request("year"));
    //             });
    //         });
    //     $patients = $patients->get()->toArray();

    //     $data = [];
    //     foreach ($patients as $patient) {

    //         if (!$patient["finished_date"]) {
    //             $patient["treatment_status"] = "On-going";
    //         } else {
    //             $month = date("m", strtotime($patient["finished_date"]));
    //             $year = date("Y", strtotime($patient["finished_date"]));
    //             if (request()->year < $year) {
    //                 $patient["treatment_status"] = "On-going";
    //             } else {
    //                 if (request()->year > $year) $patient["treatment_status"] = $this->getFinishStatus($patient["treatment_finish"]);
    //                 else {
    //                     if (request()->month < $month)  $patient["treatment_status"] = "On-going";
    //                     else $patient["treatment_status"] = $this->getFinishStatus($patient["treatment_finish"]);
    //                 }
    //             }
    //         }

    //     }

    //     return $data;
    // }
    
    public function getFinishStatus($status)
    {
        if ($status == 1) return "Stop";
        else if ($status == 2) return "Finish";
    }

    public function getHowManMonth($date)
    {
        $filterDate = request()->year . "-" . request()->month . "-01";
        $d1 = new DateTime($date);
        $d2 = new DateTime($filterDate);
        $Months = $d2->diff($d1);
        return (($Months->y) * 12) + ($Months->m);
    }
}
