<?php

namespace App\Service\Dashboard;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class MonthlyReport
{

    protected $reported_volunteers=[];

    public function get()
    {
        return [
            "No: of DR-TB pateints nominated for pre-enrolled support" => $this->getNo1(),
            "No: of newly pre-enrolled DR-TB patients supported" => $this->getNo2(),
            "No: of total pre-enrolled DR-TB patients supported (new+old)" => $this->getNo3(),
            "No: of DR-TB patients nominated for enrolled support" => $this->getNo4(),
            "No: of newly enrolled DR-TB patients supported" => $this->getNo5(),
            "No: of total enrolled DR-TB patients supported (new+old)" => $this->getNo6(),
            "No: of volunteer attendee in training conducted during this month" => $this->getNo7(),
            "No: of reported volunteers" => $this->getNo8(),
            "No: of volunteers who provide DOT" => $this->getNo9(),
            "No: of DR-TB patients who receive DOT" => $this->getNo10(),
            "No: of health education sessions conducted by volunteers" => $this->getNo11(),
            "No: of total attendants during health education sessions by volunteers" => $this->getNo12(),
            "No: of DR-TB household contacts screened for TB(vol+FO)" => $this->getNo13(),
            "No: of total presumptive TB cases referred by volunteers for examination" => $this->getNo14(),
            "No: of total presumptive TB cases examined  (referred by volunteers)" => $this->getNo15(),
            "No: of TB/DR-TB cases among total presumptive TB cases examined (referred by vol)" => $this->getNo16(),
            "No: of DR-TB household contacts examined (referred by vol+FO+self)" => $this->getNo17(),
            "No: of TB/DR-TB cases among household contacts examined (referred by vol+FO+self)" => $this->getNo18(),
            "No: of counselling sessions to DR-TB patients conducted by Field Officer" => $this->getNo19(),
            "No: of total home visits carried out by Field Officer" => $this->getNo20(),
            "No: of home visits to outside township patients carried out by Field Officer" => $this->getNo21(),
            "No: of superivsory visits to volunteers carried out by Field Officer" => $this->getNo22(),
            "No: of DR-TB Patients who transfer in from other township" => $this->getNo23(),
            "No: of DR-TB Patients who finished treatment (no documented outcome)" => $this->getNo24(),
            "No: of DR-TB Patients who cured or completed treatment" => $this->getNo25(),
            "No: of DR-TB Patients who transfer out " => $this->getNo26(),
            "No: of DR-TB Patients who lost to follow up " => $this->getNo27(),
            "No: of DR-TB Patients who expired" => $this->getNo28(),
        ];
    }

    public function township_patient($model,$sex)
    {
        return $model->whereHas("patient", function ($query) use ($sex) {
                $query->where("township_id", request("township_id"))->where("sex", $sex);
            });
    }
    
    public function township_group_patient($model,$sex)
    {
        return $model->whereHas("patient", function ($query) use ($sex){
                    $query->whereHas("township",function($query)use ($sex){
                        $query->where("township_group_id",request("township_group_id"));
                    })
                    ->where("sex", $sex);
                });
    }
    
    public function township_group_filter($model)
    {
        return $model->whereHas("township",function($query){
                        $query->where("township_group_id",request("township_group_id"));
                    });
    }
   public function getNo1()
    {
        return [
            "male" => $this->getNo1Data(1),
            "female" => $this->getNo1Data(2)
        ];
    }

    // public function getNo1Data($sex)
    // {
    //      $model=\App\Models\PreEnrollSupport::where([
    //         "nominated" => 2,
    //         "support_month" => request("month"),
    //         "support_year" => request("year"),
    //     ]);
         
    //      $filterby=request("filterby");
         
    //      if ($filterby=='1'){
    //          $model=$this->township_group_patient($model,$sex);
    //      }
         
    //      if ($filterby=='2'){
    //          $model=$this->township_patient($model,$sex);
    //      }
        
    //     return $model->count();
    // }
    
     public function getNo1Data($sex)
    {
         $filterby=request("filterby");
         
       $model=new \App\Models\PreEnrollSupport();
        
        
          if ($filterby=='1'){
             $model= $model->where([
                        "nominated" => 2,
                        "nominated_month" => request("month"),
                        "nominated_year" => request("year"),
                    ])->whereHas("patient", function ($query) use ($sex){
                        $query->whereHas("township",function($query){
                        $query->where("township_group_id",request("township_group_id"));
                    })->where("sex", $sex);
                    })->get();
         }
         
         if ($filterby=='2'){
            $model= $model->where([
                        "nominated" => 2,
                        "nominated_month" => request("month"),
                        "nominated_year" => request("year"),
                    ])->whereHas("patient", function ($query) use ($sex){
                        $query->where("township_id", request("township_id"))->where("sex", $sex);
                    })->get();
         }
        
      
        $count=1;$j=0;
        if(!$model->isEmpty())
        {
            for($i=0;$i<$model->count();$i++)
            {
                $patient_id=$model[$i]["patient_id"];
                $nominated_month=$model[$i]["nominated_month"];
                
                $j=(int)$i+1;
                $post_patient_id = isset($model[$j]["patient_id"]) ? $model[$j]["patient_id"] : false;
                $post_nomintedmonth=isset($model[$j]["nominated_month"]) ? $model[$j]["nominated_month"] : false;
                
                if($nominated_month==$post_nomintedmonth)
                    {
                        if($patient_id!=$post_patient_id)
                        {
                            $count=$count+1;
                        }else{
                            $count=$count;
                        }
                    }
                // if($nominated_month==request("month"))
            
            }
        }
        else{
            $count=0;
        }
        
        return $count;
        
    }
    
    public function getNo2()
    {
        return [
            "male" => $this->getNo2Data(1),
            "female" => $this->getNo2Data(2)
        ];
    }

    public function getNo2Data($sex)
    {
         $filterby=request("filterby");
         
         if ($filterby=='1'){
           //  $model=$this->township_group_patient($model,$sex);
              $model = \App\Models\PreEnrollSupport::whereHas('patient', function ($query)  use ($sex){
                        $query->whereHas("township",function($query){
                                $query->where("township_group_id",request("township_group_id"));
                                })
                                ->where("sex", $sex);
                    })
                    ->where("month_type", 1)
                    ->whereYear('date', request("year"));
         }
         
         if ($filterby=='2'){
              $model = \App\Models\PreEnrollSupport::whereHas('patient', function ($query)  use ($sex){
                        $query->where('township_id',request("township_id"))->where("sex", $sex);
                    })
                    ->where("month_type", 1)
                    ->whereYear('date', request("year"));
                    
            //$model=$this->township_patient($model,$sex);
         }
         
                 
        $request_month = request("month");
        $request_year = request("year");
        $startDate = Carbon::createFromFormat('Y-m-d', $request_year . '-' . ($request_month - 1) . '-' . '26')->format('Y-m-d');
        $endDate = Carbon::createFromFormat('Y-m-d', $request_year . '-' . $request_month . '-' . '25')->format('Y-m-d');
        $startDateFor7 = Carbon::createFromFormat('Y-m-d', $request_year . '-' . $request_month . '-' . '1')->format('Y-m-d');
        $endDateFor6 = Carbon::createFromFormat('Y-m-d', $request_year . '-' . $request_month . '-' . '30')->format('Y-m-d');
        $endDateFor12 = Carbon::createFromFormat('Y-m-d', $request_year . '-' . $request_month . '-' . '31')->format('Y-m-d');
        
        if (in_array($request_month, ['2', '3', '4', '5', '8', '9', '10','11'])) {
            $count = $model->whereBetween('date', [$startDate, $endDate]);
        } elseif ($request_month == '6') {
            $count = $model->whereBetween('date', [$startDate, $endDateFor6]);
        } elseif ($request_month == '7') {
            $count = $model->whereBetween('date', [$startDateFor7, $endDate]);
        } elseif ($request_month == '12') {
            $count = $model->whereBetween('date', [$startDate, $endDateFor12]);
        }
        elseif ($request_month == '1') {
            $count = $model->whereBetween('date', [$startDateFor7, $endDate]);
        }
       
        if($count)
        {
            $count=$count->groupBy('patient_id');
            return $count->get()->count();
        }else{
            return $count=0;
        }
        
        //  $model=\App\Models\PreEnrollSupport::where([
        //     "support" => 2,
        //     "support_month" => request("month"),
        //     "support_year" => request("year"),
        //     ])->where(function ($query) {
        //             $query->where("month_type", 1);
        //         });
        
       
        // return $model->count();
       
    }

    public function getNo3()
    {
        return [
            "male" => $this->getNo3Data(1),
            "female" => $this->getNo3Data(2)
        ];
    }

    public function getNo3Data($sex)
    {
        $model = \App\Models\PreEnrollSupport::where('support', 2);

        $filterby=request("filterby");
         
         if ($filterby=='1'){
             $model=$this->township_group_patient($model,$sex);
         }
         
         if ($filterby=='2'){
             $model=$this->township_patient($model,$sex);
         }
                   
                
        $request_month = request("month");
        $request_year = request("year");
        $startDate = Carbon::createFromFormat('Y-m-d', $request_year . '-' . ($request_month - 1) . '-' . '26')->format('Y-m-d');
        $endDate = Carbon::createFromFormat('Y-m-d', $request_year . '-' . $request_month . '-' . '25')->format('Y-m-d');
        $startDateFor7 = Carbon::createFromFormat('Y-m-d', $request_year . '-' . $request_month . '-' . '1')->format('Y-m-d');
        $endDateFor6 = Carbon::createFromFormat('Y-m-d', $request_year . '-' . $request_month . '-' . '30')->format('Y-m-d');
        $endDateFor12 = Carbon::createFromFormat('Y-m-d', $request_year . '-' . $request_month . '-' . '31')->format('Y-m-d');
        
        if (in_array($request_month, ['2', '3', '4', '5', '8', '9', '10','11'])) {
            $count = $model->whereBetween('date', [$startDate, $endDate]);
        } elseif ($request_month == '6') {
            $count = $model->whereBetween('date', [$startDate, $endDateFor6]);
        } elseif ($request_month == '7') {
            $count = $model->whereBetween('date', [$startDateFor7, $endDate]);
        } elseif ($request_month == '12') {
            $count = $model->whereBetween('date', [$startDate, $endDateFor12]);
        }
        elseif ($request_month == '1') {
            $count = $model->whereBetween('date', [$startDateFor7, $endDate]);
        }
        
        if($count)
        {
            $count=$count->groupBy('patient_id');
            return $count->get()->count();
        }else{
            return $count=0;
        }
    }


    public function getNo4()
    {
        return [
            "male" => $this->getNo4Data(1),
            "female" => $this->getNo4Data(2)
        ];
    }

    public function getNo4Data($sex)
    {
        
        $model=new \App\Models\EnrollSupport();
        $model= $model->where([
            "nominated" => 2,
            "nominated_month" => request("month"),
            "nominated_year" => request("year"),
        ]);
        
        $filterby=request("filterby");
         
         if ($filterby=='1'){
             $model=$this->township_group_patient($model,$sex);
         }
         
         if ($filterby=='2'){
             $model=$this->township_patient($model,$sex);
         }
        $model=$model->get();
        
        $count=0;$j=0;
        
        for($i=0;$i<$model->count();$i++)
        {
            $patient_id=$model[$i]["patient_id"];
            $norminated_month=$model[$i]["support_month"];
            
            $j=(int)$i+1;
            $post_patient_id = isset($model[$j]["patient_id"]) ? $model[$j]["patient_id"] : false;
            
            if($patient_id!=$post_patient_id)
            {
                 $count=$count+1;
            }else{
                 $count=$count;
            }
            
        //   if($norminated_month==request("month"))
        }
        
        return $count;
    }

    public function getNo5()
    {

        return [
            "male" => $this->getNo5Data(1),
            "female" => $this->getNo5Data(2)
        ];
    }

    public function getNo5Data($sex)
    {
        $model = \App\Models\EnrollSupport::where('support', 2)
                            ->where('nominated',2);
                            
        $filterby=request("filterby");
         
         if ($filterby=='1'){
             $model=$this->township_group_patient($model,$sex);
         }
         
         if ($filterby=='2'){
             $model=$this->township_patient($model,$sex);
         }
                    
        $count=$model->whereHas('patient', function ($query){
            $query->whereYear('support_startdate', request("year"));
            
            $request_month =request("month");
            $request_year = request("year");
            $startDate = Carbon::createFromFormat('Y-m-d', $request_year . '-' . ($request_month - 1) . '-' . '26')->format('Y-m-d');
            $endDate = Carbon::createFromFormat('Y-m-d', $request_year . '-' . $request_month . '-' . '25')->format('Y-m-d');
            $startDateFor7 = Carbon::createFromFormat('Y-m-d', $request_year . '-' . $request_month . '-' . '1')->format('Y-m-d');
            $endDateFor6 = Carbon::createFromFormat('Y-m-d', $request_year . '-' . $request_month . '-' . '30')->format('Y-m-d');
            $endDateFor12 = Carbon::createFromFormat('Y-m-d', $request_year . '-' . $request_month . '-' . '31')->format('Y-m-d');

            if (in_array($request_month, ['2', '3', '4', '5', '8', '9', '10',11])) {
                $query->whereBetween('support_startdate', [$startDate, $endDate]);
            } elseif ($request_month == '6') {
                $query->whereBetween('support_startdate', [$startDate, $endDateFor6]);
            } elseif ($request_month == '7') {
                $query->whereBetween('support_startdate', [$startDateFor7, $endDate]);
            } elseif ($request_month == '12') {
                $query->whereBetween('support_startdate', [$startDate, $endDateFor12]);
            }
            elseif ($request_month == '1') {
                $query->whereBetween('support_startdate', [$startDateFor7, $endDate]);
            }  
        });
        
        if($count)
        {
            $count=$count->groupBy('patient_id');
            return $count->get()->count();
        }else{
            return $count=0;
        }
        
        // return \App\Models\Patient::where("township_id", request("township_id"))
        //     ->whereMonth("support_startdate", request("month"))->whereYear("support_startdate", request("year"))->where("sex", $sex)->count();
    }

    public function getNo6()
    {
        return [
            "male" => $this->getNo6Data(1),
            "female" => $this->getNo6Data(2)
        ];
    }

    public function getNo6Data($sex)
    {
        $model = \App\Models\EnrollSupport::where('support', 2)
                    ->where('nominated',2)
                    ->whereYear('date', request("year"));
              
        $filterby=request("filterby");
         
         if ($filterby=='1'){
             $model=$this->township_group_patient($model,$sex);
         }
         
         if ($filterby=='2'){
             $model=$this->township_patient($model,$sex);
         }
                
        $request_month = request("month");
        $request_year = request("year");
        $startDate = Carbon::createFromFormat('Y-m-d', $request_year . '-' . ($request_month - 1) . '-' . '26')->format('Y-m-d');
        $endDate = Carbon::createFromFormat('Y-m-d', $request_year . '-' . $request_month . '-' . '25')->format('Y-m-d');
        $startDateFor7 = Carbon::createFromFormat('Y-m-d', $request_year . '-' . $request_month . '-' . '1')->format('Y-m-d');
        $endDateFor6 = Carbon::createFromFormat('Y-m-d', $request_year . '-' . $request_month . '-' . '30')->format('Y-m-d');
        $endDateFor12 = Carbon::createFromFormat('Y-m-d', $request_year . '-' . $request_month . '-' . '31')->format('Y-m-d');
        
        if (in_array($request_month, ['2', '3', '4', '5', '8', '9', '10','11'])) {
            $count = $model->whereBetween('date', [$startDate, $endDate]);
        } elseif ($request_month == '6') {
            $count = $model->whereBetween('date', [$startDate, $endDateFor6]);
        } elseif ($request_month == '7') {
            $count = $model->whereBetween('date', [$startDateFor7, $endDate]);
        } elseif ($request_month == '12') {
            $count = $model->whereBetween('date', [$startDate, $endDateFor12]);
        }
        elseif ($request_month == '1') {
            $count = $model->whereBetween('date', [$startDateFor7, $endDate]);
        }
        
        if($count)
        {
            $count=$count->groupBy('patient_id');
            return $count->get()->count();
        }else{
            return $count=0;
        }
    }
    
    public function getNo7()
    {
        return [
            "male" => $this->getNo7Data(1),
            "female" => $this->getNo7Data(2)
        ];
    }

    public function getNo7Data($sex)
    {
        $model= \App\Models\Volunteer::whereHas("trainings", function ($query) {
            $query->whereMonth("date", request("month"))->whereYear("date", request("year"));
        })->where("gender",$sex);

        if (request("filterby")=='1'){
            $model=$model->whereHas("township",function($query){
                $query->where("township_group_id",request("township_group_id"));
            });
        }
        if (request("filterby")=='2'){
            $model=$model->where("township_id", request("township_id"));
        }
        return $model->count();
    }
    
    public function getNo8()
    {
        $male_count = 0;
        $female_count = 0;
        $volunteers = new \App\Models\Volunteer();
        if (request("filterby")=='1'){
            $volunteers=$volunteers->whereHas("township",function($query){
                $query->where("township_group_id",request("township_group_id"));
            });
        }
        if (request("filterby")=='2'){
            $volunteers=$volunteers->where("township_id", request("township_id"));
        }
        $volunteers=$volunteers->get();
       
        foreach ($volunteers as $vol) {
            // check he 
            $heCounts = \App\Models\HeActivity::where(["volunteer_id" => $vol->id, "month" => request("month"), "year" => request("year")])->count();
            if ($heCounts > 0) {
                array_push($this->reported_volunteers,$vol);
                if ($vol->gender == 1) $male_count++;
                else if ($vol->gender == 2) $female_count++;
            } else {
                // check dots
                $noappDotsCount = \App\Models\DotsVisitReport::where(["volunteer_id" => $vol->id, "month" => request("month"), "year" => request("year")])->count();
                $appDotsCount = \App\Models\DotsVisitDate::where("volunteer_id", $vol->id)->whereMonth("date", request("month"))->whereYear("date", request("year"))->count();
                //check presumptive
                $ppCount = \App\Models\Presumptive::where("volunteer_id", $vol->id)->whereMonth("referral_date", request("month"))->whereYear("referral_date", request("year"))->count();
                if ($noappDotsCount > 0) {
                    array_push($this->reported_volunteers,$vol);
                    if ($vol->gender == 1) $male_count++;
                    else if ($vol->gender == 2) $female_count++;
            
                } 
                if($appDotsCount > 0){
                    array_push($this->reported_volunteers,$vol);
                    if ($vol->gender == 1) $male_count++;
                    else if ($vol->gender == 2) $female_count++;
                    
                }
                if ($ppCount > 0) {
                    array_push($this->reported_volunteers,$vol);
                    if ($vol->gender == 1) $male_count++;
                    else if ($vol->gender == 2) $female_count++;
            
                }
                
            }
        }

        return [
            "male" => $male_count,
            "female" => $female_count
        ];
    }

    public function getNo9()
    {
        return [
            "male" => $this->getNo9Data(1),
            "female" => $this->getNo9Data(2)
        ];
    }

    public function getNo9Data($sex)
    {
        $model = new \App\Models\Volunteer();
        $filterby=request("filterby");
        if ($filterby=='1'){
            $volunteers=$this->township_group_filter($model);
        }
        if ($filterby=='2'){
            $volunteers=$model->where("township_id", request("township_id"));
        }

        $noAppCount = $volunteers->whereHas("dots_patient", function ($query) {
                            $query->where(function ($query) {
                                $query->whereHas("dots_visit_report", function ($query) {
                                    $query->where("month", request("month"))->where("year", request("year"));
                                });
                            });
                        })->where("gender", $sex)->count();
        
        $appCount = \App\Models\Volunteer::where("township_id",request("township_id"))
            ->whereHas("dots_patient", function ($query) {
                $query->where(function ($query) {
                    $query->whereHas("dots_visit_date", function ($query) {
                        $query->whereMonth("date", request("month"))->whereYear("date", request("year"));
                    });
                });
            })->where("gender", $sex)->count();
            
        return+(int)$noAppCount+(int)$appCount;
    }

    public function getNo10()
    {
        return [
            "male" => $this->getNo10Data(1),
            "female" => $this->getNo10Data(2)
        ];
    }

    public function getNo10Data($sex)
    {
        $model =new \App\Models\DOTSPatient();
        
        $filterby=request("filterby");
         
         if ($filterby=='1'){
             $model=$this->township_group_patient($model,$sex);
         }
         
         if ($filterby=='2'){
             $model=$this->township_patient($model,$sex);
         }
         
        $appCount = $model->where(function ($query) {
                    $query->whereHas("dots_visit_date", function ($query) {
                        $query->whereMonth("date", request("month"))->whereYear("date", request("year"));
                    });
                })->count();
                
        $noappCount = $model->where(function ($query) {
                    $query->whereHas("dots_visit_report", function ($query) {
                        $query->where("month", request("month"))->where("year", request("year"));
                    });
                })->count();
                
        return  $appCount+$noappCount;
    }

    public function getNo11()
    {
        $model = \App\Models\HeActivity::whereNotNull('volunteer_id')
                                    ->where('month', request('month'))
                                    ->where('year', request('year'));
        $filterby=request("filterby");
        
        if ($filterby=='1'){
            $model=$this->township_group_filter($model);
        }
        if ($filterby=='2'){
            $model=$model->where("township_id", request("township_id"));
        }
        

        return $model->count();
    }

     public function getNo12()
    {
        $model = \App\Models\HeActivity::where('screening_person',1)
                ->where('month', request('month'))
                ->where('year', request('year'));
                
        $filterby=request("filterby");
        
        if ($filterby=='1'){
            $model=$this->township_group_filter($model);
        }
        if ($filterby=='2'){
            $model=$model->where("township_id", request("township_id"));
        }

        return [
            "male" => $model->sum("n_o_attendence_male")+ $model->sum("n_o_household_male")+$model->sum("n_o_closecontact_male"),
            "female" => $model->sum("n_o_attendence_female")+ $model->sum("n_o_household_female")+$model->sum("n_o_closecontact_female"),
        ];
        
    }
    
    public function getNo13()
    {   
        $model = \App\Models\HeActivity::where('type',2)
                ->where('month', request('month'))
                ->where('year', request('year'));
                
        $filterby=request("filterby");
        
        if ($filterby=='1'){
            $model=$this->township_group_filter($model);
        }
        if ($filterby=='2'){
            $model=$model->where("township_id", request("township_id"));
        }

        return [
            "male" => $model->sum("n_o_household_male"),
            "female" => $model->sum("n_o_household_female"),
        ];
        
        
    }

    public function getNo14()
    {
        $model = \App\Models\HeActivity::where('screening_person',1)
                ->where('month', request('month'))
                ->where('year', request('year'));

        $filterby=request("filterby");
        
        if ($filterby=='1'){
            $model=$this->township_group_filter($model);
        }
        if ($filterby=='2'){
            $model=$model->where("township_id", request("township_id"));
        }

        return [
            "male" => $model->sum("refer_male"),
            "female" => $model->sum("refer_female"),
        ];
        
    }

    // public function getNo14Data($sex)
    // {
    //     return \App\Models\Presumptive::where("case_found_at", "!=", 5)->where("volunteer_id", "!=", null)
    //         ->where("sex", $sex)->where("township_id", request("township_id"))
    //         ->whereMonth("referral_date", request("month"))->whereYear("referral_date", request("year"))
    //         ->count();
    // }
    
    public function getNo15()
    {
        return [
            "male" => $this->getNo15Data(1),
            "female" => $this->getNo15Data(2),
        ];
    }

    public function getNo15Data($sex)
    {
        $model = \App\Models\Presumptive::where("sex", $sex) 
                    ->where("case_found_at", "!=", 5)
                    ->whereHas("diagonsis", function ($query) {
                        $query->where('referral_from_id','=',5)
                                ->whereMonth("register_date", request("month"))
                                ->whereYear("register_date", request("year"));
                    });
        
        $filterby=request("filterby");
        if ($filterby=='1'){
           $model=$this->township_group_filter($model);
        }
        
        if($filterby=='2'){
            $model=$model->where(function ($query) {
                $query->where('township_id',request("township_id"))
                      ->orWhere('supporting_township',request("township_id"));
            });
        }
        
         return $model->count();
        
    }

    public function getNo16()
    {
        return [
            "male" => $this->getNo16Data(1),
            "female" => $this->getNo16Data(2),
        ];
    }

    public function getNo16Data($sex)
    {
        $model = \App\Models\Presumptive::where("sex", $sex) 
                    ->whereHas("diagonsis", function ($query) {
                        $query->where('referral_from_id','=',5)
                                ->whereMonth("register_date", request("month"))
                                ->whereYear("register_date", request("year"));
                        //check if tb
                        $query->whereIn("conclusion", [1,2]);
                    });

        $filterby=request("filterby");
        if ($filterby=='1'){
           $model=$this->township_group_filter($model);
        }
        
        if($filterby=='2'){
            $model=$model->where(function ($query) {
                $query->where('township_id',request("township_id"))
                      ->orWhere('supporting_township',request("township_id"));
            });
        }
        
        return $model->count();
    }

    public function getNo17()
    {
        return [
            "male" => $this->getNo17Data(1),
            "female" => $this->getNo17Data(2),
        ];
    }

    public function getNo17Data($sex)
    {
        $model= \App\Models\Presumptive::where("sex", $sex)
            ->where("case_found_at", 3)
            ->where("relationship", 1)
            ->whereHas("diagonsis", function ($query) {
                $query->whereMonth("register_date", request("month"))->whereYear("register_date", request("year"));
            });

        if (request("filterby")=='1'){
            $model=$model->whereHas("township",function($query){
                        $query->where("township_group_id",request("township_group_id"));
                    });
        }
        
        if(request("filterby")=='2'){
            $model=$model->where(function ($query) {
                $query->where('township_id',request("township_id"))
                        ->orWhere('supporting_township',request("township_id"));
            });
        }

        return $model->count();
        
    }

    public function getNo18()
    {
        return [
            "male" => $this->getNo18Data(1),
            "female" => $this->getNo18Data(2),
        ];
    }

    public function getNo18Data($sex)
    {
        $model= \App\Models\Presumptive::where("sex", $sex)
            ->where("relationship",1)
            ->whereHas("diagonsis", function ($query) {
                $query->whereMonth("register_date", request("month"))->whereYear("register_date", request("year"));
                //check if tb
                $query->where("conclusion", 1);
            });
            
            if (request("filterby")=='1'){
                $model=$model->whereHas("township",function($query){
                            $query->where("township_group_id",request("township_group_id"));
                        });
            }
            
            if(request("filterby")=='2'){
                $model=$model->where(function ($query) {
                    $query->where('township_id',request("township_id"))
                            ->orWhere('supporting_township',request("township_id"));
                });
            } 
            return $model->count();
            
    }


    public function getNo19()
    {
        $model = \App\Models\CounselingActivity::where('month', request('month'))
                ->where('year', request('year'));

        if (request("filterby")=='1'){
            $model=$model->whereHas("township",function($query){
                $query->where("township_group_id",request("township_group_id"));
            });
        }

        if(request("filterby")=='2')
        {
            $model=$model->where('township_id', request('township_id'));
        }
        return $model->count();
       
    }

    public function getNo20()
    {
        $model = \App\Models\HomeVisitActivity::where('month', request('month'))
                ->where('year', request('year'));

        if (request("filterby")=='1'){
            $model=$model->whereHas("township",function($query){
                $query->where("township_group_id",request("township_group_id"));
            });
        }

        if(request("filterby")=='2')
        {
            $model=$model->where('township_id', request('township_id'));
        }
        return $model->count();
        
    }

    public function getNo21()
    {
        $model = \App\Models\HomeVisitActivity::where('month', request('month'))
                ->where('year', request('year'))
                ->where('outside_township',2);

        if (request("filterby")=='1'){
            $model=$model->whereHas("township",function($query){
                $query->where("township_group_id",request("township_group_id"));
            });
        }

        if(request("filterby")=='2')
        {
            $model=$model->where('township_id', request('township_id'));
        }
        return $model->count();

    }

    public function getNo22()
    {
        $model = \App\Models\SupervisionVisitActivity::where('month', request('month'))
                ->where('year', request('year'));

        if (request("filterby")=='1'){
            $model=$model->whereHas("township",function($query){
                $query->where("township_group_id",request("township_group_id"));
            });
        }

        if(request("filterby")=='2')
        {
            $model=$model->where('township_id', request('township_id'));
        }
        return $model->count();

    }
    
    public function getNo23()
    {
        return [
            "male" => $this->getNo23Data(1),
            "female" => $this->getNo23Data(2),
        ];
    }

    public function getNo23Data($sex)
    {
        $model = \App\Models\Patient::where("t_in", 2)
                ->whereMonth("t_in_date", request("month"))
                ->whereYear("t_in_date", request("year"))
                ->where("sex", $sex);

        if (request("filterby")=='1'){
            $model=$model->whereHas("township",function($query){
                $query->where("township_group_id",request("township_group_id"));
            });
        }

        if(request("filterby")=='2')
        {
            $model=$model->where('township_id', request('township_id'));
        }     
        
        return $model->count();
       
    }

    public function getNo24()
    {
        return [
            "male" => $this->getNo24Data(1),
            "female" => $this->getNo24Data(2),
        ];
    }

    public function getNo24Data($sex)
    {
        $model =  \App\Models\Patient::whereMonth("final_outcome_date", request("month"))
                ->whereYear("final_outcome_date", request("year"))
                ->where(DB::raw('MONTH(finished_date)'), '<>', DB::raw('MONTH(issue_date)'))
                ->where("sex", $sex);
                
        if (request("filterby")=='1'){
            $model=$model->whereHas("township",function($query){
                $query->where("township_group_id",request("township_group_id"));
            });
        }

        if(request("filterby")=='2')
        {
            $model=$model->where('township_id', request('township_id'));
        }    
        return $model->count();
    }

    public function getNo25()
    {
        return [
            "male" => $this->getNo25Data(1),
            "female" => $this->getNo25Data(2),
        ];
    }

    public function getNo25Data($sex)
    {
        $model= \App\Models\Patient::whereIn("final_outcome", [1, 2])
                ->whereMonth("issue_date", request("month"))
                ->whereYear("issue_date", request("year"))
                ->where("sex", $sex);
                
        if (request("filterby")=='1'){
            $model=$model->whereHas("township",function($query){
                $query->where("township_group_id",request("township_group_id"));
            });
        }

        if(request("filterby")=='2')
        {
            $model=$model->where('township_id', request('township_id'));
        }   
        return $model->count();
    }

    public function getNo26()
    {
        return [
            "male" => $this->getNo26Data(1),
            "female" => $this->getNo26Data(2),
        ];
    }

    public function getNo26Data($sex)
    {
        $model= \App\Models\Patient::where("final_outcome", 7)
                ->whereMonth("issue_date", request("month"))
                ->whereYear("issue_date", request("year"))
                ->where("sex", $sex);
        if (request("filterby")=='1'){
            $model=$model->whereHas("township",function($query){
                $query->where("township_group_id",request("township_group_id"));
            });
        }

        if(request("filterby")=='2')
        {
            $model=$model->where('township_id', request('township_id'));
        } 
        return $model->count();
    }

    public function getNo27()
    {
        return [
            "male" => $this->getNo26Data(1),
            "female" => $this->getNo26Data(2),
        ];
    }

    public function getNo27Data($sex)
    { 
        $model= \App\Models\Patient::where("final_outcome", 4)
                ->whereMonth("issue_date", request("month"))
                ->whereYear("issue_date", request("year"))
                ->where("sex", $sex);

        if (request("filterby")=='1'){
            $model=$model->whereHas("township",function($query){
                $query->where("township_group_id",request("township_group_id"));
            });
        }

        if(request("filterby")=='2')
        {
            $model=$model->where('township_id', request('township_id'));
        } 
        return $model->count();
    }

    public function getNo28()
    {
        return [
            "male" => $this->getNo26Data(1),
            "female" => $this->getNo26Data(2),
        ];
    }

    public function getNo28Data($sex)
    {
        $model= \App\Models\Patient::where("final_outcome", 3)
                ->whereMonth("issue_date", request("month"))
                ->whereYear("issue_date", request("year"))
                ->where("sex", $sex);

        if (request("filterby")=='1'){
            $model=$model->whereHas("township",function($query){
                $query->where("township_group_id",request("township_group_id"));
            });
        }

        if(request("filterby")=='2')
        {
            $model=$model->where('township_id', request('township_id'));
        } 
        return $model->count();
    }


    public function getReportedVolunteer(){
        $this->getNo8();
        return $this->reported_volunteers;
    }

    public function getDOTSReportedVolunteer(){
        return \App\Models\Volunteer::where("township_id", request("township_id"))
           ->whereHas("dots_visit_report", function ($query) {
                $query->where("month", request("month"))->where("year", request("year"));
            })->get();
    }
}