<?php

namespace App\Service\Dashboard;

use Illuminate\Support\Facades\Hash;


class Member extends CustomClassContainer
{

    private $PD = 1;
    private $PO = 2;
    private $MEALMANAGER = 3;
    private $MEALOFFICER = 4;
    private $PROGRAMMANAGER = 5;
    private $DPD = 6;
     private $CLINIC = 7;


    private $PICTS = 1;
    private $MDR = 2;

    private $PICTS1 = 1;
    private $PICTS2 = 2;
    private $MDR1 = 3;
    private $MDR22 = 4;

    function __construct()
    {
        parent::__construct(new \App\Models\Member);
    }

    public function login($data)
    {
        $model = $this->model->where("username", $data["username"])->first();
        if (!$model) {
            return false;
        } else {
            if (!Hash::check($data["password"], $model->password)) {
                return false;
            } else {
                return $model;
            }
        }
    }

    public function changePassword($data, $user_id)
    {
        $model = $this->model->where("id", $user_id)->first();
        if (!$model) {
            return false;
        } else {
            if (Hash::check($data["old_password"], $model->password)) {
                $model->password = bcrypt($data["new_password"]);
                $model->update();
                return $model;
            } else {
                return false;
            }
        }
    }


    public function save($data)
    {
        $insertedData = [
            "username" => $data["username"],
            "role" => $data["role"],
            "password" => rand(10000, 99999)
        ];

        if ($data["role"] == $this->PROGRAMMANAGER || $data["role"] == $this->CLINIC || $data["role"] == $this->MEALOFFICER || $data["role"] == $this->PO || $data["role"] == $this->DPD) {
            $insertedData["project"] = $data["project"];
        }

        if ($data["role"] == $this->PROGRAMMANAGER || $data["role"] == $this->CLINIC) {
            $insertedData["township_group_id"] = $data["township_group_id"];
        }
        return $this->model->create($insertedData);
    }


    public function getAll($data)
    {
        $this->filter(["name", "username", "role"], $data);
        return $this->model->where("status", 1)->get();
    }

    public function update($data)
    {
        $model = $this->getEach("id", $data["id"]);

        $insertedData = [
            "username" => $data["username"],
            "role" => $data["role"],
        ];

        if ($data["role"] == $this->PROGRAMMANAGER || $data["role"] == $this->CLINIC || $data["role"] == $this->MEALOFFICER || $data["role"] == $this->PO || $data["role"] == $this->DPD) {
            $insertedData["project"] = $data["project"];
        } else {
            $insertedData["project"] = NULL;
        }

        if ($data["role"] == $this->PROGRAMMANAGER || $data["role"] == $this->CLINIC) {
            $insertedData["township_group_id"] = $data["township_group_id"];
        } else {
            $insertedData["township_group_id"] = NULL;
        }

        $model->update($insertedData);
        return $model;
    }

    public function delete($id)
    {
        $model = $this->getEach("id", $id);
        $model->status = 0;
        $model->update();
        return true;
    }
}
