<?php

namespace App\Service\Dashboard;

class HomeVisit extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\HomeVisitActivity());
    }
    
    public function withColumn()
    {
        $this->model = $this->model->with([
            "township" => function ($query) {
                $query->with([
                    "township_group" ]);
            },"patient",
        ]);
        // $this->model = $this->model->with([
        //     "patient" => function ($query) {
        //             $query->with(["mdrtbRegiments" => function ($query) {
        //                 $query->orderBy("created_at", "desc");
        //             },"dots_patient"]);
        //         },
        //     "township" => function ($query) {
        //         $query->with([
        //             "township_group" ]);
        //     },
        // ]);
    $this->model=$this->model->whereHas("township",function($query){
                            $query->whereIn('township_group_id', [1, 2]);    
                        });
                        
                        
    }

    public function getEach($column = null, $value = null)
    {
        $this->withColumn();
        return $this->model->where($column, $value)->first();
    }


    public function getAll($data)
    {
        $month=(int)$data['month'];
        
        
        if( $month<13)
        {
            $this->withColumn();
            $this->filter(["month", "year", "id","township_id","is_alert"], $data);
        }
        if( $month==13)
        {
             $this->withColumn();
             $this->filter(["year", "id","is_alert"], $data);
             $this->model->whereBetween('month',[1,3]);
        }
        if( $month==14)
        {
             $this->withColumn();
             $this->filter(["year", "id","is_alert"], $data);
             $this->model->whereBetween('month',[4,6]);
        }
        if( $month==15)
        {
             $this->withColumn();
             $this->filter(["year", "id","is_alert"], $data);
             $this->model->whereBetween('month',[7,9]);
        }
        if( $month==16)
        {
             $this->withColumn();
             $this->filter(["year", "id","is_alert"], $data);
             $this->model->whereBetween('month',[10,12]);
        }
       if( $month==17)
        {
             $this->withColumn();
             $this->filter(["year", "id","is_alert"], $data);
             $this->model->whereBetween('month',[1,6]);
        }
        if( $month==18)
        {
             $this->withColumn();
             $this->filter(["year", "id","is_alert"], $data);
             $this->model->whereBetween('month',[7,12]);
        }
        if( $month==19)
        {
            $this->withColumn();
          $this->filter(["year", "id","is_alert"], $data);
             $this->model->whereBetween('month',[1,12]);
        }
     
        
        return $this->model->get();
    }
    
   
     public function export($data)
    {
        $query=$this->model->orderBy("created_at","asc");
        
        if (isset($data["start_date"]) && $data['end_date'])
            {
                $query->whereBetween('date', [$data['start_date'], $data['end_date']]);  
            }
            
        if (isset($data["township_id"]))
            {
                $query->where("township_id",$data["township_id"]);        
            }
            else if (isset($data["township_group_id"]))
            {
                if($data["township_group_id"]=='6' || $data["township_group_id"]==6)
                {
                     $query->whereHas("township",function($query) use ($data) {
                        $query->where("township_group_id",1)
                            ->OrWhere("township_group_id",2)
                            ->orderBy("id");
                    });
                }
                else{
                    $query->whereHas("township",function($query) use ($data) {
                    $query->where("township_group_id",$data["township_group_id"])->orderBy("id");
                    });
                }
                
                
            }
            
         return $query->get();
         
    }
}
