<?php

namespace App\Service\Dashboard;



class HighSideEffect extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\HighSideEffect);
    }

    public function save($data)
    {
        return $this->model->create([
            "name" => $data["name"],
            "eng_name" => $data["eng_name"],
            "code" => $data["code"],
            "description" => $data["description"],
        ]);
    }


    public function withColumn()
    {
        $this->model = $this->model->with([
         //   "township"
        ]);
    }

    public function getEach($column = null, $value = null)
    {
        $this->withColumn();
        return $this->model->where($column, $value)->first();
    }


    public function getAll($data)
    {
        $this->withColumn();
        $this->filter(["code"], $data);
        return $this->model->where("status", 1)->get();
    }

    public function update($data)
    {
        $model = $this->getEach("id", $data["id"]);
        $model->update([
            "name" => $data["name"],
            "eng_name" => $data["eng_name"],
            "code" => $data["code"],
            "description" => $data["description"],
        ]);
        return $model;
    }

    public function delete($id)
    {
        $model = $this->getEach("id", $id);
        $model->status = 0;
        $model->update();
        return true;
    }
}
