<?php

namespace App\Service\Dashboard;

class FamilyMember extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\Presumptive());
    }

    public function getEach($column = null, $value = null)
    {
        return $this->model->where($column, $value)->first();
    }


    public function getAll($data)
    {
        $this->filter(["patient_id"], $data);
        return $this->model->where("status", 1)->get();
    }
    
     public function update($data)
    {
        $model = $this->getEach("id", $data["id"]);
        return $model->update([
            "name" => $data["name"],
            "sex" => $data["sex"],
            "age" => $data["age"],
            "eligible" => $data["eligible"],
            "reason" => $data["eligible"]=='2'?null:$data["reason"],
        ]);
    }

}
