<?php

namespace App\Service\Dashboard;

class DOTSVisitReport extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\DotsVisitReport());
    }

    public function withColumn()
    {
        $this->model = $this->model->with([
            "dots_patient", "volunteer"
        ]);
    }

    public function getEach($column = null, $value = null)
    {
        $this->withColumn();
        return $this->model->where($column, $value)->first();
    }


    public function getAll($data)
    {
        $this->withColumn();
        $this->filter(["dots_patient_id"], $data);
        return $this->model->get();
    }

    public function getExistedData()
    {

        return  $this->model->where("month", request("month"))->where("year", request("year"))->where("dots_patient_id",request("dots_patient_id"))->first();
    }

    public function save($data)
    {
        if ($exitedData = $this->getExistedData()) {
            $insertedData = ["status" => $data["status"], "volunteer_id" => \App\Models\DOTSPatient::where("id", $data["dots_patient_id"])->first()->volunteer_id,];
            $exitedData->update($insertedData);
            if ($insertedData["status"] == 1) {
                $this->updateDOTSEndDate();
            }
            else {
                $this->updateCurrentStatus();
            }
            return $this->getEach("id", $exitedData->id);
        } else {
            $insertedData = [
                "month" => $data["month"],
                "year" => $data["year"],
                "dots_patient_id" => $data["dots_patient_id"],
                "volunteer_id" => \App\Models\DOTSPatient::where("id", $data["dots_patient_id"])->first()->volunteer_id,
                "status" => $data["status"],
            ];

            if ($insertedData["status"] == 1) {
                $this->updateDOTSEndDate();
            }
            else {
                $this->updateCurrentStatus();
            }
            return $this->model->create($insertedData);
        }
    }

    public function updateCurrentStatus()
    {
        $patient = \App\Models\DOTSPatient::where("id", request("dots_patient_id"))->first();
        $patient->current_status = request("status");
        $patient->update();
    }

    public function updateDOTSEndDate()
    {
        $patient = \App\Models\DOTSPatient::where("id", request("dots_patient_id"))->first();
        $patient->dots_enddate = request("date");
        $patient->current_status = request("status");
        $patient->update();

        $dotsActivity = \App\Models\DotsMainActivity::where("dots_patient_id", request("dots_patient_id"))->orderBy("created_at", "desc")->first();
        $dotsActivity->dots_enddate = request("date");
        $dotsActivity->update();
    }

    public function delete($id)
    {
        $model = $this->getEach("id", $id);
        $model->delete();
        return true;
    }
}
