<?php

namespace App\Service\Dashboard;
use Illuminate\Support\Facades\DB;

class DOTSPatient extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\DOTSPatient());
    }

    public function withColumn()
    {
        $this->model = $this->model->with([
            "patient" => function ($query) {
                $query->with([
                    "mdrtbRegiments" => function ($query) {
                    $query->orderBy("created_at", "desc");
                }]);
            }, "volunteer"
        ]);
    }

    public function getEach($column = null, $value = null)
    {
        $this->withColumn();
        return $this->model->where($column, $value)->first();
    }


    public function getExcelExportData($data)
    {
        $dotspatients=new \App\Models\DOTSPatient();
        
        $dotspatients=$dotspatients->with([
                            "patient" => function ($query) {
                                $query->with([
                                    "mdrtbRegiments"]);
                            }, "volunteer"
                        ]);
                        
         $dotspatients=$dotspatients->first();
                        
        return $dotspatients->patient->mdrtbRegiments[0]['id'];
        //  $this->withColumn();
     
        // if (isset($data["dots_startdate"])) {
        //     $this->model->where('dots_startdate',$data["dots_startdate"]);
        // }
       
        // if (isset($data["dots_app_status"])) {
        //     $this->model->where('dots_app_status',$data["dots_app_status"]);
        // }
        
        // if(isset($data["township_id"])){
        //     $township_id=$data["township_id"];
        //     $this->model->whereHas("patient", function ($query) use ($township_id) {
        //         $query->where("township_id",$township_id);
        //     });
        // }
       
        // return $this->model->get();
    }
    
    public function getAll($data)
    {
        $this->withColumn();
        $this->filter(["patient_id", "current_status", "dots_app_status"], $data);

        $now = \Carbon\Carbon::now();
        if (isset($data["reported_status"])) {
            if ($data["reported_status"] == 2) {

                $this->model = $this->model->whereHas("dots_visit_report", function ($query) use ($now) {
                    $query->where("month", $now->month)->where("year", $now->year);
                });
            } else if ($data["reported_status"] == 1) {
                $this->model = $this->model->whereDoesntHave("dots_visit_report", function ($query) use ($now) {
                    $query->where("month", $now->month)->where("year", $now->year);
                });
            }
        }   

        if (request("township_id")){
            $this->model=$this->model->whereHas("patient", function ($query) {
                $query->where("township_id", request("township_id"));
            });
        }

        if (request("township_group_id")){
            $this->model=$this->model->whereHas("patient", function ($query) {
                $query->whereHas("township",function($query){
                    $query->where("township_group_id",request("township_group_id"));
                });
            });
        }

        if (request("region_id")){
            $this->model=$this->model->whereHas("patient", function ($query) {
                $query->whereHas("township",function($query){
                    $query->where("region_id",request("region_id"));
                });
            });
        }

        return $this->model->get();
    }


  
}
