<?php

namespace App\Service\Dashboard;

class DOTSActivity extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\DotsMainActivity());
    }

    public function withColumn()
    {
        $this->model = $this->model->with([
            "dots_patient", "volunteer"
        ]);
    }

    public function getEach($column = null, $value = null)
    {
        $this->withColumn();
        return $this->model->where($column, $value)->first();
    }


    public function getAll($data)
    {
        $this->withColumn();
        $this->filter(["dots_patient_id"], $data);
        return $this->model->get();
    }

    public function update($data)
    {
        $model = $this->getEach("id", $data["id"]);
        $insertedData = [
            'dots_startdate' => $data['dots_startdate'],
            'dots_enddate' => $data['dots_enddate'],
        ];

        $patient = \App\Models\DOTSPatient::where("id", $model->dots_patient_id)->first();
        $patient->dots_startdate = $data["dots_startdate"];
        $patient->dots_enddate = $data["dots_enddate"];
        $patient->update();

        return $model->update($insertedData);
    }

    public function save($data)
    {
        $insertedData = $this->model->create([
            "dots_startdate" => $data["dots_startdate"],
            "dots_patient_id" => $data["dots_patient_id"],
            "volunteer_id" => $data["volunteer_id"],
            "dots_app_status"=>$data["dots_app_status"]
        ]);

        $patient = \App\Models\DOTSPatient::where("id", $data["dots_patient_id"])->first();
        $patient->dots_startdate = $data["dots_startdate"];
        $patient->dots_enddate = null;
        $patient->dots_app_status =$data["dots_app_status"];
        $patient->current_status = 0;
        $patient->volunteer_id = $data["volunteer_id"];
        $patient->update();
        return $insertedData;
    }

    public function delete($id)
    {
        $model = $this->getEach("id", $id);
        $model->delete();
        return true;
    }
}
