<?php

namespace App\Service\Dashboard;
class DA extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\DA);
    }

    public function save($data)
    {
        return $this->model->create([
            "name" => $data["name"],
            "township_group_id" => $data["township_group_id"],
            "password" => rand(10000, 99999)
        ]);
    }

    public function withColumn()
    {
        $this->model = $this->model->with([
            "township_group",
        ]);
    }

    public function getEach($column = null, $value = null)
    {
        $this->withColumn();
        return $this->model->where($column, $value)->first();
    }



    public function getAll($data)
    {
        $this->withColumn();
        $this->filter(["name", "township_group_id"], $data);
        return $this->model->where("status", 1)->get();
    }

    public function update($data)
    {
        $model = $this->getEach("id", $data["id"]);
        $model->update([
            "name" => $data["name"],
            "township_group_id" => $data["township_group_id"],
        ]);
        return $model;
    }

    public function delete($id)
    {
        $model = $this->getEach("id", $id);
        $model->status = 0;
        $model->update();
        return true;
    }
}
