<?php

namespace App\Service\Dashboard;

use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;

class Admin extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\Admin);
    }

    public function login($data)
    {
        $model = $this->model->where("email", $data["email"])->first();
        
        if (!$model) {
            return false;
        } else {
            if (!Hash::check($data["password"], $model->password)) {
                return false;
            } else {
                return $model;
            }
        }
    }

    public function changePassword($data, $user_id)
    {
        $model = $this->model->where("id", $user_id)->first();
        if (!$model) {
            return false;
        } else {
            if (Hash::check($data["old_password"], $model->password)) {
                $model->password = bcrypt($data["new_password"]);
                $model->update();
                return $model;
            } else {
                return false;
            }
        }
    }


    public function save($data)
    {
        $pw=rand(10000, 99999);
        return $this->model->create([
            "name" => $data["name"],
            "email" => $data["email"],
            "role" => $data["role"],
            "password" => bcrypt($pw),
            "plain_password"=>$pw
        ]);
    }


    public function getAll($data)
    {
        $this->filter(["name", "email"], $data);
        return $this->model->get();
    }

    public function update($data)
    {
        $model = $this->getEach("id", $data["id"]);
        $model->update([
            "name" => $data["name"],
            "email" => $data["email"],
            "role" => $data["role"],
        ]);
        return $model;
    }

    public function delete($id)
    {
        $model = $this->getEach("id", $id);
        $model->delete();
        return true;
    }
}
