<?php

namespace App\Service\DA;

class VolunteerTraining extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\VolunteerTraining());
    }

    public function save($data)
    {
        return $this->model->create([
            "date" => $data["date"],
            "training_type_id" => $data["training_type_id"],
            "volunteer_id" => $data["volunteer_id"],
        ]);
    }

    public function withColumn()
    {
        $this->model = $this->model->with([
            
        ]);
    }

    public function getEach($column = null, $value = null)
    {
        $this->withColumn();
        return $this->model->where($column, $value)->first();
    }


    public function getAll($data)
    {
        $this->withColumn();
        $this->filter(["date", "volunteer_id"], $data);
        return $this->model->where("status", 1)->get();
    }




    public function delete($id)
    {
        $model = $this->getEach("id", $id);
        $model->status = 0;
        $model->update();
        return true;
    }
}
