<?php

namespace App\Service\DA;

class Volunteer extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\Volunteer());
    }

    public function getEach($column = null, $value = null)
    {
        $this->withColumn();
        return $this->model->where($column, $value)->first();
    }

    public function withColumn()
    {
        $this->model = $this->model->with([
            "township",
            "trainings" => function ($query) {
                $query->where("status", 1);
            }
        ]);
    }


    public function getAll($data)
    {
        $this->withColumn();
        $this->filter(["name", "code", "id","township_id"], $data);
        
        if(isset($data['township_id']))
        {
            return $this->model->where("status", 1)
                    ->where("township_id",$data['township_id'])
                    ->orderBy('name')->get();
        }
        
        return $this->model->where("status", 1)
            ->whereHas("township", function ($query) {
                $query->where("township_group_id", request()->user()->township_group_id);
            })
            ->orderBy('name')->get();
    }
}
