<?php

namespace App\Service\DA;
use Illuminate\Support\Facades\Auth;

class SupervisionVisit extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\SupervisionVisitActivity());
    }

    public function save($data)
    {
        $insertedData = [
            "month" => $data["month"],
            "year" => $data["year"],
            "patient_id" => $data["patient_id"],
            "volunteer_id" => $data["volunteer_id"],
            "radio_value_list" => json_encode($data["radio_value_list"]),
            "dots_type" => $data["dots_type"],
            "supervision_type" => $data["supervision_type"],
            "remark" => $data["remark"],
            "date" => $data["date"],
            "township_id" => $data["township_id"],
        ];


        return $this->model->create($insertedData);
    }



    public function withColumn()
    {
        $this->model = $this->model->with([
            "township", "patient","volunteer"
        ]);
    }

    public function getEach($column = null, $value = null)
    {
        $this->withColumn();
        return $this->model->where($column, $value)->first();
    }


    public function getAll($data)
    {
        $this->withColumn();
        $this->filter(["month", "year", "id"], $data);
        
        if($data["township_id"]=="township_group")
        {
           return $this->model->whereHas("township",function($query){
                $query->where("township_group_id",Auth::user()->township_group_id);
            })->get();
        }else
        {
        return $this->model
            ->where("township_id", $data["township_id"])
            ->get();
        }
        
    }


    public function update($data)
    {
        $model = $this->getEach("id", $data["id"]);
        $insertedData = [
            "month" => $data["month"],
            "year" => $data["year"],
            "patient_id" => $data["patient_id"],
            "volunteer_id" => $data["volunteer_id"],
            "radio_value_list" => json_encode($data["radio_value_list"]),
            "dots_type" => $data["dots_type"],
            "supervision_type" => $data["supervision_type"],
            "remark" => $data["remark"],
            "date" => $data["date"],
            "township_id" => $data["township_id"],
        ];
        return $model->update($insertedData);
    }



    public function delete($id)
    {
        $model = $this->getEach("id", $id);
        $model->delete();
        return true;
    }
}
