<?php

namespace App\Service\DA;

class ReferPatient extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\Presumptive());
    }

    public function save($data)
    {



        $insertedData = [
            "existing_presumptive" => $data["existing_presumptive"],
            "township_id" => $data["township_id"],
            "volunteer_id" => $data["volunteer_id"],
            "referral_date" => $data["referral_date"],
            "case_found_at" => $data["case_found_at"],
            "confirm" => 0
        ];

        if ($insertedData["existing_presumptive"]==1)
        {
            $insertedData["name"]=$data["name"];
            $insertedData["sex"]=$data["sex"];
            $insertedData["age"]=$data["age"];
        }
        else if ($insertedData["existing_presumptive"]==2)
        {
            $insertedData["existing_presumptive_id"]=$data["existing_presumptive_id"];
        }

        if ($insertedData["case_found_at"] == 2 || $insertedData["case_found_at"] == 3) {
            $insertedData["index_case_no"] = $data["index_case_no"];
            $insertedData["index_case_year"] = $data["index_case_year"];
            $insertedData["index_case_initial"] = $data["index_case_initial"];
            $insertedData["relationship"] = $data["relationship"];
        } else if ($insertedData["case_found_at"] == 6) {
            $insertedData["previousID"] = $data["previousID"];
        }




        return $this->model->create($insertedData);
    }

    public function getEach($column = null, $value = null)
    {
        $this->withColumn();
        return $this->model->where($column, $value)->first();
    }

    public function withColumn()
    {
        $this->model = $this->model->with([
            "volunteer", "township","case_found_at_name","existing_presumptive_data",
        ]);
    }


    public function getAll($data)
    {
        $this->withColumn();
        $this->filter(["patient_id", "volunteer_id","township_id"], $data);
        return $this->model->where("status", 1)->where("volunteer_id", "!=", NULL)->get();
    }

    public function update($data)
    {
        $model = $this->getEach("id", $data["id"]);
        $insertedData = [
            "name" => $data["name"],
            "sex" => $data["sex"],
            "age" => $data["age"],
            
            "volunteer_id" => $data["volunteer_id"],
            "referral_date" => $data["referral_date"],
            "case_found_at" => $data["case_found_at"],
            "confirm" => 0
        ];

        if ($insertedData["case_found_at"] == 2 || $insertedData["case_found_at"] == 3) {
            $insertedData["index_case_no"] = $data["index_case_no"];
            $insertedData["index_case_year"] = $data["index_case_year"];
            $insertedData["index_case_initial"] = $data["index_case_initial"];
            $insertedData["relationship"] = $data["relationship"];
            $insertedData["previousID"] = NULL;
        } else if ($insertedData["case_found_at"] == 6) {
            $insertedData["previousID"] = $data["previousID"];
            $insertedData["index_case_no"] = NULL;
            $insertedData["index_case_year"] = NULL;
            $insertedData["index_case_initial"] = NULL;
            $insertedData["relationship"] = NULL;
        } else {
            $insertedData["previousID"] = NULL;
            $insertedData["index_case_no"] = NULL;
            $insertedData["index_case_year"] = NULL;
            $insertedData["index_case_initial"] = NULL;
            $insertedData["relationship"] = NULL;
        }

        return $model->update($insertedData);
    }

    public function delete($id)
    {
        $model = $this->getEach("id", $id);
        $model->status = 0;
        $model->update();
        return true;
    }
}
