<?php

namespace App\Service\DA;

class PresumptiveDiagnosis extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\PresumptiveDiagnosis());
    }

    public function saveForRefer($data)
    {
        $existingPresumptive = \App\Models\Presumptive::where("id", $data["presumptive_id"])->first();
        if ($existingPresumptive) {
            $insertedData = [
                "existing_presumptive" => 2,
                "existing_presumptive_id" => $existingPresumptive->id,
                "referral_date" => $data["referral_date"],
                "volunteer_id" => $data["volunteer_id"],
                "referral_from_id" => $data["referral_from_id"],
                "township_id" => $existingPresumptive->township_id,
                "case_found_at" => $existingPresumptive->case_found_at,
                "index_case_no" => $existingPresumptive->index_case_no,
                "index_case_year" => $existingPresumptive->index_case_year,
                "index_case_initial" => $existingPresumptive->index_case_initial,
                 "index_case_monopoly" => $existingPresumptive->index_case_monopoly,
                "previousID" => $existingPresumptive->previousID,
            ];

            if ($data["refer_or_examine"] == 1) $insertedData["confirm"] = 0;
            else if ($data["refer_or_examine"] == 2) $insertedData["confirm"] = 1;



            $model = new \App\Models\Presumptive;
            $model->create($insertedData);
        }
    }

    public function getLastTime($id) {
    $record = $this->model->where("presumptive_id", $id)->orderBy("id", "desc")->first();
    
    if ($record) {
        return $record->times + 1;
    } else {
        return 1;
    }
}


    public function addNew($data)
    {
        //$this->saveForRefer($data);
        
           $this->model->weight = $data["weight"];
           
        if ($data["refer_or_examine"] == 2) {
            $lastTime = $this->getLastTime( $data["presumptive_id"]);
            $this->model->presumptive_id = $data["presumptive_id"];

            $this->model->hiv_status = $data["hiv_status"];

            $this->model->times = $lastTime;

            if ($data["hiv_status"] == 3) {
                $this->model->hiv_date = $data["hiv_date"];
                $this->model->hiv_result = $data["hiv_result"];
                $this->model->hiv_code = $data["hiv_code"];
            }

            $this->model->sputum_status = $data["sputum_status"];

            if ($data["sputum_status"] == 3) {
                $this->model->sputum_date = $data["sputum_date"];
                $this->model->sputum_result = $data["sputum_result"];
            }


            $this->model->cxr_status = $data["cxr_status"];

            if ($data["cxr_status"] == 3) {
                $this->model->cxr_date = $data["cxr_date"];
                $this->model->cxr_result = $data["cxr_result"];
            }



            $this->model->gene_xpert_status = $data["gene_xpert_status"];

            if ($data["gene_xpert_status"] == 3) {
                $this->model->gene_xpert_date = $data["gene_xpert_date"];
                $this->model->gene_xpert_result = $data["gene_xpert_result"];
            }

            $this->model->culture_status = $data["culture_status"];

            if ($data["culture_status"] == 3) {
                $this->model->culture_date = $data["culture_date"];
                $this->model->culture_result = $data["culture_result"];
            }



            $this->model->dst_status = $data["dst_status"];

            if ($data["dst_status"] == 3) {
                $this->model->dst_date = $data["dst_date"];
                $this->model->dst_result = json_encode($data["dst_result"]);
            }

            $this->model->other_investigation_status = $data["other_investigation_status"];

            if ($data["other_investigation_status"] == 3) {
                $this->model->other_investigation_date = $data["other_investigation_date"];
                $this->model->other_investigation_test = $data["other_investigation_test"];
                $this->model->other_investigation_result = $data["other_investigation_result"];
            }

            $this->model->conclusion = $data["conclusion"];
            $this->model->conclusion_code = $data["conclusion_code"];
            $this->model->other_comment = $data["other_comment"];

            $this->model->register_date = $data["reg_date"];

            $this->model->referral_type_id = $data["referral_type_id"];

            $this->model->referral_from_id = $data["referral_from_id"];

            // link refer presumptive  to diagonsis by ID
            if (isset($data["refer_id"])){
                $this->model->refer_id=$data["refer_id"];
            }
            else {
                $this->model->refer_id=$data["presumptive_id"];
            }
            
            $this->model->save();

            $this->model->symptons()->detach();
            $this->model->risk_factors()->detach();
         
            foreach ($data["symptons"] as $item) {
                $this->model->symptons()->attach($item);
            }
            
            foreach ($data["risk_factors"] as $item) {
                $this->model->risk_factors()->attach($item);
            }

            $this->withColumns();
            $result = $this->model->orderBy("id", "desc")->first();

            return $result;
        }
    }


    public function getAll($data)
    {
        $this->filter(["presumptive_id"], $data);
        $this->withColumns();
        return $this->model->where("status", 1)->get();
    }


    public function withColumns()
    {
        $this->model = $this->model->with(
            [
                "hiv_result_name",
                "sputum_result_name",
                "gene_xpert_result_name",
                "culture_result_name",
                "dst_result_name",
                "cxr_result_name",
                "conclusion_name",
                "refer_from_name",
                "refer_type_name",
                "symptons",
                "risk_factors",
            ]
        );
    }


    public function getEach($column = null, $value = null)
    {
        $this->withColumns();
        return $this->model->where($column, $value)->first();
    }

   public function delete($id)
    {
        $model = $this->model->where('presumptive_id',$id);
        $model->delete();
        return true;
    }
    
    public function deleteEach($id)
    {
        $model = $this->getEach("id", $id);
        $model->delete();
        return true;
    }


    public function update($data)
    {
        $this->withColumns();
        $model = $this->getEach("id", $data["id"]);

        $model->hiv_status = $data["hiv_status"];
        $model->weight = $data["weight"];
        
        if ($data["hiv_status"] == 3) {
            $model->hiv_date = $data["hiv_date"];
            $model->hiv_result = $data["hiv_result"];
            $model->hiv_code = $data["hiv_code"];
        } else {
            $model->hiv_date = NULL;
            $model->hiv_result = NULL;
            $model->hiv_code = NULL;
        }

        $model->sputum_status = $data["sputum_status"];

        if ($data["sputum_status"] == 3) {
            $model->sputum_date = $data["sputum_date"];
            $model->sputum_result = $data["sputum_result"];
        } else {
            $model->sputum_date = NULL;
            $model->sputum_result = NULL;
        }


        $model->cxr_status = $data["cxr_status"];

        if ($data["cxr_status"] == 3) {
            $model->cxr_date = $data["cxr_date"];
            $model->cxr_result = $data["cxr_result"];
        } else {
            $model->cxr_date = NULL;
            $model->cxr_result = NULL;
        }



        $model->gene_xpert_status = $data["gene_xpert_status"];

        if ($data["gene_xpert_status"] == 3) {
            $model->gene_xpert_date = $data["gene_xpert_date"];
            $model->gene_xpert_result = $data["gene_xpert_result"];
        } else {
            $model->gene_xpert_date = NULL;
            $model->gene_xpert_result = NULL;
        }

        $model->culture_status = $data["culture_status"];

        if ($data["culture_status"] == 3) {
            $model->culture_date = $data["culture_date"];
            $model->culture_result = $data["culture_result"];
        } else {
            $model->culture_date = NULL;
            $model->culture_result = NULL;
        }



        $model->dst_status = $data["dst_status"];

        if ($data["dst_status"] == 3) {
            $model->dst_date = $data["dst_date"];
            $model->dst_result = json_encode($data["dst_result"]);
        } else {
            $model->dst_date = NULL;
            $model->dst_result = NULL;
        }

        $model->other_investigation_status = $data["other_investigation_status"];

        if ($data["other_investigation_status"] == 3) {
            $model->other_investigation_date = $data["other_investigation_date"];
            $model->other_investigation_test = $data["other_investigation_test"];
            $model->other_investigation_result = $data["other_investigation_result"];
        } else {
            $model->other_investigation_date = NULL;
            $model->other_investigation_test = NULL;
            $model->other_investigation_result = NULL;
        }

        $model->conclusion = $data["conclusion"];
        $model->conclusion_code = $data["conclusion_code"];
        $model->other_comment = $data["other_comment"];

        $model->register_date = $data["register_date"];

        $model->referral_type_id = $data["referral_type_id"];

        $model->referral_from_id = $data["referral_from_id"];
        
        $model->symptons()->detach();
        $model->risk_factors()->detach();
         
        foreach ($data["symptons"] as $item) {
            $model->symptons()->attach($item);
        }
        
        foreach ($data["risk_factors"] as $item) {
            $model->risk_factors()->attach($item);
        }

      

        // $model->symptons()->attach($data["symptons"]);
        // $model->risk_factors()->attach($data["risk_factors"]);

        $model->update();
    }

    public function getExcelExportData($data)
    {
        $this->model=$this->model->orderBy("times","asc");
        
        $this->model=$this->model->whereHas("presumptive",function($query) use($data) {
          
          $this->model=$this->model->with([
                            "presumptive" => function ($query) {
                                $query->with([
                                    "supportingTownship"]);
                            }
                        ]);
                        
            if (isset($data["township_id"]))
            {
                $query->where("township_id",$data["township_id"]);        
            }
            else if (isset($data["township_group_id"]))
            {
                if($data["township_group_id"]=='6' || $data["township_group_id"]==6)
                {
                    $query->whereHas("township",function($query){
                                $query->whereIn('township_group_id', [1, 2]);
                                })->orderBy("id");
                }
                else{
                    $query->whereHas("township",function($query) use ($data) {
                    $query->where("township_group_id",$data["township_group_id"])->orderBy("id");
                    });
                }
                
                
            }
            else if (isset($data["region_id"]))
            {
                $query->whereHas("township",function($query) use ($data) {
                    $query->where("region_id",$data["region_id"])->orderBy("id");
                });
                
            }
        });
        
        $this->model=$this->model->whereHas("presumptive",function($query){
            $query->where("status",1)->orderBy("township_id");
        });
        
         $this->model = $this->model->with("presumptive",function($query){
            $query->where("status",1);
        });
        
        if (request("start_date") && request("end_date")){
            $this->model=$this->model->whereBetween("register_date",[request("start_date"),request("end_date")]);
        }
        
        $alldata=$this->getAll($data);
      

        return $alldata;

    }


}
