<?php

namespace App\Service\DA;

class Presumptive extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\Presumptive());
        $this->presumptiveDiagnosis = new \App\Service\DA\PresumptiveDiagnosis;
        $this->patientService = new \App\Service\DA\Patient;
    }

    public function getByIndexCode($data)
    {
        $this->withColumns();
        $this->model = $this->model->where("index_case_no", $data["index_case_no"])->where("index_case_year", $data["index_case_year"]);
        
        if($data["index_case_monopoly"])
        {
             $this->model = $this->model->where("index_case_monopoly", $data["index_case_monopoly"]);
        }
        
        // if ($data["index_case_initial"]) {
        //     $this->model = $this->model->where("index_case_initial", $data["index_case_initial"]);
        // }

        if ($data["case_found_at"]) {
            $this->model = $this->model->where("case_found_at", $data["case_found_at"]);
        }
        
        if(isset($data["patient_id"]))
        {
             $this->model = $this->model->where("status",1)->whereNotNull("patient_id");
        }

        $data = $this->model->where("township_id", $data["township_id"])->where("status", 1)->get();

        if (count($data) == 0 && request("case_found_at") == 5) {
            $data = $this->patientService->getByIndexCode(request()->all());
        }

        return $data ;
    }

    public function addNew($data)
    {
        $insertedData = [];
      
        if (!isset($data["family_member_id"])) {
            $insertedData = [
                'name' => $data["name"],
                'sex' =>  $data["sex"],
                'age' =>  $data["age"],
                'case_found_at' =>  $data["case_found_at"],
                'township_id' => $data["township_id"],
                'supporting_township' =>  $data["supporting_township"],
                'referral_from_id' => $data['referral_from_id']
            ];
            if ($insertedData["case_found_at"] == 3 || $insertedData["case_found_at"] == 5) {
                $insertedData["index_case_no"] = $data["index_case_no"];
                $insertedData["index_case_year"] = $data["index_case_year"];
                $insertedData["index_case_initial"] = $data["index_case_initial"];
                $insertedData["relationship"] = $data["relation"];
            }
        }
        

        if ($data["referral_from_id"]  == 1) {
            $insertedData["volunteer_id"] = $data["volunteer_id"];
            $insertedData["referral_date"] = $data["referral_date"];
        }


        if ($data["refer_or_examine"] == 1) {
            $insertedData["confirm"] = 0;
        } else {
            $insertedData["confirm"] = 1;
            $insertedData["unique_number"] = $this->getUniqueNumber($data);
            $insertedData["serial"] = $data["no"];
        }

        // manage existing here 
        $insertedData["existing_presumptive"] = 1;


        $result = null;

        // check the presumptive is already saved as family member
        if (!isset($data["family_member_id"]) && !isset($data["presumptive_id"])) {
            $result = $this->model->create($insertedData);
        } 
        else {
            
            if(isset($data["presumptive_id"])){
                
                $result = $this->model->update($insertedData);
            }
             
            $already_id=isset($data["family_member_id"])?$data["family_member_id"]:$data["presumptive_id"];
            
            $result = $this->getEach("id", $already_id);
            $result->referral_from_id = $data["referral_from_id"];
            $result->volunteer_id = $data["volunteer_id"];
            $result->referral_date = $data["referral_date"];
            $result->existing_presumptive = 1;

            if ($data["refer_or_examine"] == 1) {
                $result->confirm = 0;
            } else {
                $result->confirm = 1;
                $insertedData["confirm"] = 1;
                $result->unique_number = $this->getUniqueNumber($data);
                $result->serial = $data["no"];
            }

            $result->update();
        }
        
        $id=isset($data['presumptive_id'])?$data['presumptive_id']:$result->id;

        // save diagonis if presumptive doesn't stop at refer
        if ($result->confirm == 1) {
            $this->saveDiagnosis($id, $data);
        }


        return $result;
    }

    public function editInfo($data)
    {

        $model = $this->getEach("id", $data["id"]);
        
        $insertedData = [
            'name' => $data["name"],
            'sex' =>  $data["sex"],
            'age' =>  $data["age"],
            'serial' =>  $data["no"],
            'case_found_at' =>  $data["case_found_at"],
            'supporting_township' =>  $data["supporting_township"],
            'unique_number' => $this->getUniqueNumber($data),
            'township_id' => $data["township_id"],
        ];

        if ($insertedData["case_found_at"] == 3 || $insertedData["case_found_at"] == 5) {
            $insertedData["index_case_no"] = $data["index_case_no"];
            $insertedData["index_case_year"] = $data["index_case_year"];
            $insertedData["index_case_initial"] = $data["index_case_initial"];
            $insertedData["relationship"] = $data["relationship"];
            $insertedData["previousID"] = NULL;
        } else {
            $insertedData["index_case_no"] = NULL;
            $insertedData["index_case_year"] = NULL;
            $insertedData["index_case_initial"] = NULL;
            $insertedData["previousID"] = NULL;
            $insertedData["relationship"] = NULL;
        }




        $model->update($insertedData);
    }

    public function getUniqueNumber($data)
    {
        $code = null;


        if ($data["no"] < 10) $code = "0000";
        else if ($data["no"] < 100) $code = "000";
        else if ($data["no"] < 1000) $code = "00";
        else if ($data["no"] < 10000) $code = "0";


        $code .= $data["no"];


        $initial = \App\Models\Township::where("id", request("township_id"))->first()->short_code;

        return $initial . "_" . \Carbon\Carbon::now()->year . "_" . $code;
    }

    public function getAll($data)
    {
        $this->filter(["township_id"], $data);
        $this->withColumns();
        return $this->model->where("status", 1)->where("confirm", 1)->get();
    }
    
     public function getSupportingTownshipPresumptive($data)
    {
        $this->withColumns();
        return $this->model->where("status", 1)->whereIn("confirm", [0, 1])->where('supporting_township',$data['township_id'])->get();
    }

    public function withColumns()
    {
        $this->model = $this->model->with(
            [

                "case_found_at_name",
                "township",
                "volunteer",
                "existing_presumptive_data",
            

                "diagonsis" => function ($query) {
                    $query->where('status', 1);
                    $query->with(
                        [
                            "symptons",
                            "risk_factors",
                            "hiv_result_name",
                            "sputum_result_name",
                            "gene_xpert_result_name",
                            "culture_result_name",
                            "dst_result_name",
                            "cxr_result_name",
                            "conclusion_name",
                            "refer_from_name",
                            "refer_type_name",

                        ]
                    );
                }
            ]
        );
    }

    public function saveDiagnosis($patientID, $data)
    {
        $model = new \App\Models\PresumptiveDiagnosis;

        if (isset($data["refer_id"])) {
            $model->refer_id = $patientID;
            $model->presumptive_id = $data["presumptive_id"];
            $model->times = $this->presumptiveDiagnosis->getLastTime($data["presumptive_id"]);
        } else {
            $model->presumptive_id = $patientID;
        }


        $model->hiv_status = $data["hiv_status"];

        if ($data["hiv_status"] == 3) {
            $model->hiv_date = $data["hiv_date"];
            $model->hiv_result = $data["hiv_result"];
            $model->hiv_code = $data["hiv_code"];
        }

        $model->sputum_status = $data["sputum_status"];

        if ($data["sputum_status"] == 3) {
            $model->sputum_date = $data["sputum_date"];
            $model->sputum_result = $data["sputum_result"];
        }


        $model->cxr_status = $data["cxr_status"];

        if ($data["cxr_status"] == 3) {
            $model->cxr_date = $data["cxr_date"];
            $model->cxr_result = $data["cxr_result"];
        }



        $model->gene_xpert_status = $data["gene_xpert_status"];

        if ($data["gene_xpert_status"] == 3) {
            $model->gene_xpert_date = $data["gene_xpert_date"];
            $model->gene_xpert_result = $data["gene_xpert_result"];
        }

        $model->culture_status = $data["culture_status"];

        if ($data["culture_status"] == 3) {
            $model->culture_date = $data["culture_date"];
            $model->culture_result = $data["culture_result"];
        }



        $model->dst_status = $data["dst_status"];

        if ($data["dst_status"] == 3) {
            $model->dst_date = $data["dst_date"];
            $model->dst_result = json_encode($data["dst_result"]);
        }

        $model->other_investigation_status = $data["other_investigation_status"];

        if ($data["other_investigation_status"] == 3) {
            $model->other_investigation_date = $data["other_investigation_date"];
            $model->other_investigation_test = $data["other_investigation_test"];
            $model->other_investigation_result = $data["other_investigation_result"];
        }

        $model->conclusion = $data["conclusion"];
        $model->conclusion_code = $data["conclusion_code"];
        $model->other_comment = $data["other_comment"];

        $model->register_date = $data["reg_date"];

        $model->referral_type_id = $data["referral_type_id"];



        $model->referral_from_id = $data["referral_from_id"];

        $model->save();

        foreach ($data["symptons"] as $item) {
            $model->symptons()->attach($item);
        }
        
        foreach ($data["risk_factors"] as $item) {
            $model->risk_factors()->attach($item);
        }
    }

    public function getEach($column = null, $value = null)
    {
        $this->withColumns();
        return $this->model->where($column, $value)->first();
    }

    public function delete($id)
    {
        $model = $this->getEach("id", $id);
        $ci = \App\Models\Ci::where('presumptive_id', $id)->first();
         
        $model->delete();
        
        if ($ci) {
            $ci->delete();
        }
                        
        return true;
    }

    public function saveAsPresumptive($data)
    {
        $model = $this->getEach("id", $data["id"]);
        $insertedData = [];


        $insertedData = [
            'serial' =>  $data["no"],
            'confirm' => 1,
            'unique_number' => $this->getUniqueNumber($data),
        ];


        $this->model->update($insertedData);
        $this->saveDiagnosis($data["id"], $data);
        return $model;
    }
}
