<?php

namespace App\Service\DA;

use App\Service\Utils\FileService;

class PreEnrollSupport extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\PreEnrollSupport());
    }

    public function save($data)
    {

        $insertedData = [
            "patient_id" => $data["patient_id"],
            "nominated" => $data["nominated"],
            "support_month" => $data["support_month"],
            "support_year" => $data["support_year"],
            "month_type" => $data["month_type"],
            "remark" => $data["remark"],
        ];

        if ($data["nominated"] == 2) {
            $insertedData["support"] = $data["support"];
            $insertedData["nominated_month"] = $data["nominated_month"];
            $insertedData["nominated_year"] = $data["nominated_year"];
            
            if ($data["support"] == 2) {

                $insertedData["date"] = $data["date"];
                $insertedData["type"] = $data["type"];
                $insertedData["repay"] = $data["repay"];




                if ($insertedData["type"] == 1) {
                    $insertedData["delagated"] = $data["delagated"];
                    if ($insertedData["delagated"] == 2) {
                        $insertedData["delagated_person_id"] = $data["delagated_person_id"];
                    }
                    if ($data["signature"]) {
                        $signature = FileService::save($data["signature"], "patients/enrolls/supports");
                        $insertedData["signature"] = $signature;
                    }
                }
            }
        }

        return $this->model->create($insertedData);
    }

    public function withColumn()
    {
        $this->model = $this->model->with([
            "delagated_person"
        ]);
    }

    public function getEach($column = null, $value = null)
    {
        $this->withColumn();
        return $this->model->where($column, $value)->first();
    }


    public function getAll($data)
    {
        $this->withColumn();
        $this->filter(["patient_id"], $data);
        return $this->model->where("status", 1)->orderBy("support_month", "asc")->orderBy("support_year", "asc")->get();
    }

    public function update($data)
    {
        $model = $this->getEach("id", $data["id"]);

        $insertedData = [
            "nominated" => $data["nominated"],
            "support_month" => $data["support_month"],
            "support_year" => $data["support_year"],
        ];

        if ($data["nominated"] == 2) {
            $insertedData["support"] = $data["support"];
            if ($data["support"] == 2) {
                if ($data["support"] == 2 && $data["signature"] != "null") {
                    $signature = FileService::save($data["signature"], "patients/pre_enrolls/supports");
                    $insertedData["signature"] = $signature;
                }

                $insertedData["date"] = $data["date"];
            }
        }


        return $model->update($insertedData);
    }

    public function delete($id)
    {
        $model = $this->getEach("id", $id);
        $model->delete();
        return true;
    }

    public function checkError()
    {
        $patient = \App\Models\Patient::where("id", request("patient_id"))->first();
        $yesCount = $this->model->where("patient_id", request()->patient_id)->where("support", 2)->where("status", 1)->count();
        if ($yesCount >= 2) {
            return [
                "success" => false,
                "message" => "Support have been given two times"
            ];
        }

        $yesCount = $this->model->where([
            "support_month" => request()->support_month,
            "support_year" => request()->support_year,
            "patient_id" => request()->patient_id,
            "status" => 1,
            "support" => 2,
        ])->count();
        if ($yesCount > 0)
            return [
                "success" => false,
                "message" => "Support have been for this month"
            ];



        if (request("support") == 2) {


            $date1 = strtotime(request("support_year") . "-" . request("support_month") . "-01");
            $date2 = strtotime(request("date"));

            if ($date2 < $date1) {
                return [
                    "success" => false,
                    "message" => "Support date should be larger than support month and year"
                ];
            }
        }

        if (request("support") == 2) {
            if ($patient->finished_date) {
                $date1 = strtotime($patient->finished_date);
                $date2 = strtotime(request("support_year") . "-" . request("support_month") . "-01");
                if ($date2 > $date1) {
                    return [
                        "success" => false,
                        "message" => "Date should not be greater than Finished Date "
                    ];
                }
            }
        }

        if (request("month_type") != 3) {
            $yesCount = \App\Models\PreEnrollSupport::where("patient_id", request("patient_id"))->where("support", 2)->where("month_type", 3)->count();
            if ($yesCount > 0) {
                return [
                    "success" => false,
                    "message" => "Month 1+2 have been given"
                ];
            }

            $yesCount = \App\Models\PreEnrollSupport::where("patient_id", request("patient_id"))->where("support", 2)->where("month_type", request("month_type"))->count();
            if ($yesCount > 0) {
                return [
                    "success" => false,
                    "message" => "Support have been given to that month type"
                ];
            }
        } else {
            $yesCount = \App\Models\PreEnrollSupport::where("patient_id", request("patient_id"))->where("support", 2)->where("month_type", request("month_type"))->count();
            if ($yesCount > 2) {
                return [
                    "success" => false,
                    "message" => "Support have been given to that month type"
                ];
            }
            $yesCount = \App\Models\PreEnrollSupport::where("patient_id", request("patient_id"))->where("support", 2)->whereIn("month_type", [1, 2])->count();
            if ($yesCount > 0) {
                return [
                    "success" => false,
                    "message" => "Support have been given to another month type"
                ];
            }
        }

        if (request("month_type") == 2) {
            $yesCount = \App\Models\PreEnrollSupport::where("patient_id", request("patient_id"))->where("support", 2)->where("month_type", 1)->count();
            if ($yesCount == 0) {
                return [
                    "success" => false,
                    "message" => "Support have to be given to Month 1 first"
                ];
            }
        }

        if (request("support") == 2) {
            $yesCount = $this->model->where([
                "patient_id" => request("patient_id"),
                "status" => 1,
                "support" => 2,
                "date" => request("date"),
            ])->first();

            if ($yesCount) {
                if ($yesCount->type != request("type")) {
                    return [
                        "success" => false,
                        "message" => "Same payment channel should be used"
                    ];
                }
            }
        }

        $lastSupport = $this->model->where(["patient_id" => request("patient_id"), "status" => 1])->orderBy("id", "desc")->first();
        if ($lastSupport) {
            if (request("support_month") == 1) {
                if ($lastSupport->support_month != 12) {
                    return [
                        "success" => false,
                        "message" => "Your support month should be in order"
                    ];
                }
            } else {
                if (request("support_year") == $lastSupport->support_year) {
                    if (request("support_month") - $lastSupport->support_month > 1) {
                        return [
                            "success" => false,
                            "message" => "Your support month should be in order"
                        ];
                    }
                }
            }
        }






        return [
            "success" => true
        ];
    }
}
