<?php

namespace App\Service\DA;
use Illuminate\Support\Facades\Auth;

class HomeVisit extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\HomeVisitActivity());
    }
    public function save($data)
    {
        $insertedData = [
            'type' => $data['type'],
            'patient_id' => $data['patient_id'],
            'date' => $data['date'],
            'se_checklist' => json_encode($data['se_checklist']),
            'infection_control' => json_encode($data['infection_control']),
            'month' => $data['month'],
            'year' => $data['year'],
            'outside_township' => $data['outside_township'],
            'lived_patients_no' => $data['lived_patients_no'],
            "township_id" => $data["township_id"],
        ];


        return $this->model->create($insertedData);
    }
    
    public function withColumn()
    {
        $this->model = $this->model->with([
            "township", "patient"
        ]);
    }

    public function getEach($column = null, $value = null)
    {
        $this->withColumn();
        return $this->model->where($column, $value)->first();
    }


    public function test($data)
    {
        $this->withColumn();
        $this->filter(["month", "year", "id"], $data);
            
        if($data["township_id"]=="township_group")
        {
           return $this->model->whereHas("township",function($query){
                $query->where("township_group_id",Auth::user()->township_group_id);
            })->get();
        }else
        {
        return $this->model
            ->where("township_id", $data["township_id"])
            ->get();
        }
    }
    
    public function getAll($data)
    {
        
        $month=(int)$data['month'];
        
        
        if( $month<13)
        {
            $this->withColumn();
            $this->filter(["month", "year", "id","township_id","is_alert"], $data);
        }
        if( $month==13)
        {
             $this->withColumn();
             $this->filter(["year", "id","is_alert"], $data);
             $this->model->whereBetween('month',[1,3]);
        }
        if( $month==14)
        {
             $this->withColumn();
             $this->filter(["year", "id","is_alert"], $data);
             $this->model->whereBetween('month',[4,6]);
        }
        if( $month==15)
        {
             $this->withColumn();
             $this->filter(["year", "id","is_alert"], $data);
             $this->model->whereBetween('month',[7,9]);
        }
        if( $month==16)
        {
             $this->withColumn();
             $this->filter(["year", "id","is_alert"], $data);
             $this->model->whereBetween('month',[10,12]);
        }
       if( $month==17)
        {
             $this->withColumn();
             $this->filter(["year", "id","is_alert"], $data);
             $this->model->whereBetween('month',[1,6]);
        }
        if( $month==18)
        {
             $this->withColumn();
             $this->filter(["year", "id","is_alert"], $data);
             $this->model->whereBetween('month',[7,12]);
        }
        if( $month==19)
        {
            $this->withColumn();
          $this->filter(["year", "id","is_alert"], $data);
             $this->model->whereBetween('month',[1,12]);
        }
     
         return  $this->model->whereHas("township",function($query){
                    $query->where("township_group_id",Auth::user()->township_group_id);
                })->where("township_id", $data["township_id"])
                ->get();
        
            
        }
    


    public function update($data)
    {
        $model = $this->getEach("id", $data["id"]);
        $insertedData = [
            'type' => $data['type'],
            'patient_id' => $data['patient_id'],
            'date' => $data['date'],
            'outside_township' => $data['outside_township'],
            'lived_patients_no' => $data['lived_patients_no'],
            'se_checklist' => json_encode($data['se_checklist']),
            'infection_control' => json_encode($data['infection_control']),

        ];
        return $model->update($insertedData);
    }



    public function delete($id)
    {
        $model = $this->getEach("id", $id);
        $model->delete();
        return true;
    }
}
