<?php

namespace App\Service\DA;
use Illuminate\Support\Facades\Auth;

class He extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\HeActivity());
    }

    public function save($data)
    {
       $insertedData = [
            "date" => $data["date"],
            "remark" => $data["remark"],
            "place" => $data["place"],
            "month" => $data["month"],
            "year" => $data["year"],
            "type" => $data["type"],
            "screening_person"=>$data["screening_person"],
            "township_id" =>  $data["township_id"],
            "supporting_township_id"=>$data["supporting_township_id"],
            "refer_male"=>$data["refer_male"]==null?0:$data["refer_male"],
            "refer_female"=>$data["refer_female"]==null?0:$data["refer_female"],
        ];
        
        if($insertedData["screening_person"]==1)
        {
             $insertedData["volunteer_id"] = $data["volunteer_id"];
        }
         if ($insertedData["type"] == 1) {
            $insertedData["n_o_attendence_male"]=$data["n_o_attendence_male"];
            $insertedData["n_o_attendence_female"]=$data["n_o_attendence_female"];
         }
         
        if ($insertedData["type"] == 2) {
            $insertedData["index_case_no"] = $data["index_case_no"];
            $insertedData["index_case_year"] = $data["index_case_year"];
             $insertedData["monopoly"] = $data["index_case_monopoly"];
            $insertedData["index_case_initial"] = $data["index_case_initial"];
            $insertedData["n_o_household_male"]=$data["n_o_household_male"];
            $insertedData["n_o_household_female"]=$data["n_o_household_female"];
            $insertedData["n_o_closecontact_male"]=$data["n_o_closecontact_male"];
            $insertedData["n_o_closecontact_female"]=$data["n_o_closecontact_female"];
        }

        return $this->model->create($insertedData);
    }



    public function withColumn()
    {
         $this->model = $this->model->with([
            "township" => function ($query) {
                $query->with([
                    "township_group" ]);
            }, "volunteer"
        ]);
    }

    public function getEach($column = null, $value = null)
    {
        $this->withColumn();
        return $this->model->where($column, $value)->first();
    }


    public function getAll($data)
    {
        $this->withColumn();
      
        $month=(int)$data['month'];
        
        if( $month<13)
        {
            $this->filter(["month","year", "id"], $data);
        }
        if( $month==13)
        {
             $this->filter(["year", "id"], $data);
             $this->model->whereBetween('month',[1,3]);
        }
        if( $month==14)
        {
             $this->filter(["year", "id"], $data);
             $this->model->whereBetween('month',[4,6]);
        }
        if( $month==15)
        {
             $this->filter(["year", "id"], $data);
             $this->model->whereBetween('month',[7,9]);
        }
        if( $month==16)
        {
             $this->filter(["year", "id"], $data);
             $this->model->whereBetween('month',[10,12]);
        }
        if( $month==17)
        {
             $this->filter(["year", "id"], $data);
             $this->model->whereBetween('month',[1,6]);
        }
        if( $month==18)
        {
             $this->filter(["year", "id"], $data);
             $this->model->whereBetween('month',[7,12]);
        }
        
        if($data["township_id"]=="township_group")
        {
           return $this->model->whereHas("township",function($query){
                $query->where("township_group_id",Auth::user()->township_group_id);
            })->get();
        }else
        {
        return $this->model
            ->where("township_id", $data["township_id"])
            ->get();
        }
    }
    
    public function export($data)
    {
        $this->withColumn();
        $year=$data['year'];
        
        if( $data['month']<13){
            $this->filter(["month", "year", "id"], $data);
        }
        if( $data['month']==13)
        {
             $this->filter(["year", "id","is_alert"], $data);
             $this->model->whereBetween('month',[1,3]);
        }
        if($data['month']==14)
        {
             $this->filter(["year", "id","is_alert"], $data);
             $this->model->whereBetween('month',[4,6]);
        }
        if( $data['month']==15)
        {
             $this->filter(["year", "id","is_alert"], $data);
             $this->model->whereBetween('month',[7,9]);
        }
        if( $data['month']==16)
        {
             $this->filter(["year", "id","is_alert"], $data);
             $this->model->whereBetween('month',[10,12]);
        }
         if($data['month']==17)
        {
             $this->filter([ "year","id","is_alert"], $data);
             $this->model->whereBetween('month',[1,6]);
        }
         if($data['month']==18)
        {
             $this->filter(["year", "id","is_alert"], $data);
             $this->model->whereBetween('month',[7,12]);
        }
       
       if(isset($data['township_id']))
       {
           if($data["township_id"]=="township_group")
        {
           return $this->model->whereHas("township",function($query){
                $query->where("township_group_id",auth()->user() );
            })->get();
        }else{
         return $this->model
            ->where("township_id",$data['township_id'])
            ->get();   
        }
            
            if($data['township_id']=='undefined')
           {
                 return $this->model
                ->get();
           }
       }
       
         return $this->model
                ->get();
       
       
    }


    public function update($data)
    {
        $model = $this->getEach("id", $data["id"]);

        $insertedData = [
            "date" => $data["date"],
            "remark" => $data["remark"],
            "place" => $data["place"],
            "type" => $data["type"],
             "screening_person"=>$data["screening_person"],
            "supporting_township_id"=>$data["supporting_township_id"],
            "refer_male"=>$data["refer_male"],
            "refer_female"=>$data["refer_female"],
        ];

        if($insertedData["screening_person"]==1)
        {
             $insertedData["volunteer_id"] = $data["volunteer_id"];
        }
        
        if($insertedData["screening_person"]==2)
        {
             $insertedData["volunteer_id"] =NULL;
        }
        
         if ($insertedData["type"] == 1) {
            $insertedData["n_o_attendence_male"]=$data["n_o_attendence_male"];
            $insertedData["n_o_attendence_female"]=$data["n_o_attendence_female"];
            $insertedData["index_case_no"] = NULL;
            $insertedData["index_case_year"] = NULL;
             $insertedData["monopoly"] = 1;
            
            $insertedData["n_o_household_female"]=0;
            $insertedData["n_o_household_male"]=0;
            $insertedData["n_o_closecontact_male"]=0;
            $insertedData["n_o_closecontact_female"]=0;
         }
         
        if ($insertedData["type"] == 2) {
            $insertedData["n_o_attendence_male"]=0;
            $insertedData["n_o_attendence_female"]=0;
            $insertedData["index_case_no"] = $data["index_case_no"];
            $insertedData["index_case_year"] = $data["index_case_year"];
             $insertedData["monopoly"] = $data["index_case_monopoly"];
            $insertedData["n_o_household_male"]=$data["n_o_household_male"];
            $insertedData["n_o_household_female"]=$data["n_o_household_female"];
             $insertedData["n_o_closecontact_male"]=$data["n_o_closecontact_male"];
            $insertedData["n_o_closecontact_female"]=$data["n_o_closecontact_female"];
        } 


        return $model->update($insertedData);
    }



    public function delete($id)
    {
        $model = $this->getEach("id",$id);
        $model->delete();
        return true;
    }
}
