<?php

namespace App\Service\DA;

use App\Service\Utils\FileService;

class EnrollSupport extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\EnrollSupport());
    }

    public function save($data)
    {

        $insertedData = [
            "patient_id" => $data["patient_id"],
            "nominated" => $data["nominated"],
            "support_month" => $data["support_month"],
            "support_year" => $data["support_year"],
            "remark" => $data["remark"],
        ];

        if ($data["nominated"] == 2) {
            $insertedData["nominated_month"] = $data["nominated_month"];
            $insertedData["nominated_year"] = $data["nominated_year"];
            $insertedData["support"] = $data["support"];
            if ($data["support"] == 2) {

                $insertedData["date"] = $data["date"];
                $insertedData["type"] = $data["type"];
                $insertedData["repay"] = $data["repay"];

                $this->updateSupportStartDate($data["date"],$data["patient_id"]);


                if ($insertedData["type"] == 1) {
                    $insertedData["delagated"] = $data["delagated"];
                    if ($insertedData["delagated"] == 2) {
                        $insertedData["delagated_person_id"] = $data["delagated_person_id"];
                    }
                    if ($data["signature"]) {
                        $signature = FileService::save($data["signature"], "patients/enrolls/supports");
                        $insertedData["signature"] = $signature;
                    }
                }
            }
        }



        return $this->model->create($insertedData);
    }

    public function withColumn()
    {
        $this->model = $this->model->with([
            "delagated_person"
        ]);
    }

    public function getEach($column = null, $value = null)
    {
        $this->withColumn();
        return $this->model->where($column, $value)->first();
    }

    public function updateSupportStartDate($date,$patientID)
    {
        $support_date=$date==null ? null:$date;
        $supportCount=\App\Models\EnrollSupport::where("patient_id",$patientID)->count();
        if ($supportCount==0)
        {
            \App\Models\Patient::where("id",$patientID)->update(["support_startdate"=>$support_date]);
        }
    }


    public function getAll($data)
    {
        $this->withColumn();
        $this->filter(["patient_id"], $data);
        // return $this->model->where("status", 1)->orderBy("support_month", "asc")->orderBy("support_year", "asc")->orderBy("repay", "asc")->get();
        return $this->model->where("status", 1)->orderBy("date")->get();
    }

    public function delete($id)
    {
        $model = $this->getEach("id", $id);
        $model->delete();
        return true;
    }

    public function update($data)
    {
        $model = $this->getEach("id", $data["id"]);

        $insertedData = [
            "nominated" => $data["nominated"],
            "support_month" => $data["support_month"],
            "support_year" => $data["support_year"],
            "reason_for_lost"=>$data["reason_for_lost"]?$data["reason_for_lost"]:null,
        ];

        if ($data["nominated"] == 2) {
            $insertedData["support"] = $data["support"];
            
            if ($data["support"] == 2) {
                $insertedData["type"] = $data["type"];

                if ($data["support"] == 2 && isset($data["signature"]) && $data["signature"] != "null") {

                    if ($insertedData["type"] == 1) {
                        $signature = FileService::save($data["signature"], "patients/enrolls/supports");
                        $insertedData["signature"] = $signature;
                    }
                }

                if ($data["type"] != 1) {
                    $insertedData["signature"] = null;
                }

                $insertedData["date"] = $data["date"];
            }
        }


        return $model->update($insertedData);
    }

    public function checkError()
    {

        $patient = \App\Models\Patient::where("id", request("patient_id"))->first();
        $yesCount = $this->model->where([
            "support_month" => request()->support_month,
            "support_year" => request()->support_year,
            "patient_id" => request()->patient_id,
            "status" => 1,
            "support" => 2,
        ])->count();
        if ($yesCount > 0)
            return [
                "success" => false,
                "message" => "Support have been for this month"
            ];


        $date1 = strtotime($patient->treatment_startdate);
        $date2 = strtotime(request("support_year") . "-" . request("support_month") . "-31");
        if ($date2 < $date1) {
            return [
                "success" => false,
                "message" => "Support month and year should be larger than treatment startdate (" . $patient->treatment_startdate . ")"
            ];
        }

        if (request("support") == 2) {

            $date1 = strtotime($patient->treatment_startdate);
            $date2 = strtotime(request("date"));
            if ($date2 < $date1) {
                return [
                    "success" => false,
                    "message" => "Support date should be larger than treatment startdate (" . $patient->treatment_startdate . ")"
                ];
            }


            $date1 = strtotime(request("support_year") . "-" . request("support_month") . "-01");
            $date2 = strtotime(request("date"));

            if ($date2 < $date1) {
                return [
                    "success" => false,
                    "message" => "Support date should be larger than support month and year"
                ];
            }
        }

        if (request("support") == 2) {
            $yesCount = $this->model->where([
                "patient_id" => request()->patient_id,
                "status" => 1,
                "support" => 2,
                "date" => request("date"),
            ])->first();

            if ($yesCount) {
                if ($yesCount->type != request("type")) {
                    return [
                        "success" => false,
                        "message" => "Same payment channel should be used"
                    ];
                }
            }
        }


        if ($patient->finished_date) {
            $date1 = strtotime($patient->finished_date);
            $date2 = strtotime(request("support_year") . "-" . request("support_month") . "-01");
            if ($date2 > $date1) {
                return [
                    "success" => false,
                    "message" => "Date should not be greater than Finished Date "
                ];
            }
        }


        $lastSupport = $this->model->where(["patient_id" => request("patient_id"), "status" => 1])->orderBy("date", "desc")->orderBy("created_at", "desc")->first();
            if ($lastSupport) {
                if (request("support_month") == 1) {
                    // if ($lastSupport->support_month != 12) {
                    //     return [
                    //         "success" => false,
                    //         "message" =>  $lastSupport->support_month
                    //     ];
                    // }
                } else {
                    if (request("support_year") == $lastSupport->support_year) {
                        if (request("support_month") - $lastSupport->support_month > 1) {
                            return [
                                "success" => false,
                                "message" => "Your support month should be in order"
                            ];
                        }
                    }
                }
            }
        // $lastSupport = $this->model->where(["patient_id" => request("patient_id"), "status" => 1])->orderBy("date", "desc")->first();
        // if ($lastSupport) {
        //     if (request("support_month") == 1) {
        //         if ($lastSupport->support_month != 12) {
        //             return [
        //                 "success" => false,
        //                 "message" => "Your support month should be in order"
        //             ];
        //         }
        //     } else {
        //         if (request("support_year") == $lastSupport->support_year) {
        //             if (request("support_month") - $lastSupport->support_month > 1) {
        //                 return [
        //                     "success" => false,
        //                     "message" => "Your support month should be in order"
        //                 ];
        //             }
        //         }
        //     }
        // }



        return [
            "success" => true
        ];
    }
}
