<?php

namespace App\Service\DA;

use App\Service\Utils\FileService;

class DelagatedPerson extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\DelagatedPerson());
    }

    public function save($data)
    {
        $insertedData = [
            "name" => $data["name"],
            "sex" => $data["sex"],
            "age" => $data["age"],
            "relationship" => $data["relationship"],
            "patient_id" => $data["patient_id"],
        ];

       
        return $this->model->create($insertedData);
    }

    public function getEach($column = null, $value = null)
    {
        return $this->model->where($column, $value)->first();
    }


    public function getAll($data)
    {
        $this->filter(["patient_id"], $data);
        return $this->model->get();
    }

    public function update($data)
    {
        $model = $this->getEach("id", $data["id"]);

        $insertedData = [
            "name" => $data["name"],
            "sex" => $data["sex"],
            "age" => $data["age"],
            "relationship" => $data["relationship"],
            "patient_id" => $data["patient_id"],
        ];

       

        return $model->update($insertedData);
    }

    public function delete($id)
    {
        $model = $this->getEach("id", $id);

        $model->delete();
        return true;
    }
}
