<?php

namespace App\Service\DA;
use Illuminate\Support\Facades\Auth;

class Couseling extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\CounselingActivity());
    }

    public function save($data)
    {
        $insertedData = [
            'month' => $data["month"],
            'year' => $data["year"],
            'date' => $data["date"],
            'phone' => $data["phone"],
            'patient_id' => $data["patient_id"],
            'less_than_5_count' => $data["less_than_5_count"],
            'between_5_and_14_count' => $data["between_5_and_14_count"],
            'greate_than_15' => $data["greate_than_15"],
            "township_id" => $data["township_id"],
        ];


        $result = $this->model->create($insertedData);

        foreach ($data["topics"] as $item) {
            $topicModel = new \App\Models\CounselingActivityTopic;
            $topicModel->counseling_activity_id =  $result->id;
            $topicModel->topic_id =  $item;
            $topicModel->save();
        }


        return $result;
    }



    public function withColumn()
    {
        $this->model = $this->model->with([
            "township", "topics","patient"
        ]);
    }

    public function getEach($column = null, $value = null)
    {
        $this->withColumn();
        return $this->model->where($column, $value)->first();
    }


    public function getAll($data)
    {
        $this->withColumn();
        $this->filter(["month", "year", "id"], $data);
        
        // return $this->model
        //   ->where("township_id", request("township_id"))
        //     ->get();
            
        if($data["township_id"]=="township_group")
        {
            return $this->model->whereHas("township",function($query){
                $query->where("township_group_id",Auth::user()->township_group_id);
            })->get();
        }else
        {
            return $this->model
            ->where("township_id", $data["township_id"])
            ->get();
        }
    }


    public function update($data)
    {
        $model = $this->getEach("id", $data["id"]);

        $insertedData = [
            'date' => $data["date"],
            'phone' => $data["phone"],
            'patient_id' => $data["patient_id"],
            'less_than_5_count' => $data["less_than_5_count"],
            'between_5_and_14_count' => $data["between_5_and_14_count"],
            'greate_than_15' => $data["greate_than_15"],
        ];

        \App\Models\CounselingActivityTopic::where("counseling_activity_id", $data["id"])->delete();

        foreach ($data["topics"] as $item) {
            $topicModel = new \App\Models\CounselingActivityTopic;
            $topicModel->counseling_activity_id =  $data["id"];
            $topicModel->topic_id =  $item;
            $topicModel->save();
        }

        return $model->update($insertedData);
    }



    public function delete($id)
    {
        $model = $this->getEach("id", $id);
        $model->delete();
        return true;
    }
}
