<?php

namespace App\Service\DA;
use Illuminate\Support\Facades\DB;

class Ci extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\Ci());
        $this->patientService = new \App\Service\DA\Patient;
    }
    
    public function getAll($data)
    {
        $this->filter(["township_id"], $data);
     
        $this->model->whereMonth('date',$data['month'])
                    ->whereYear('date',$data['year']);
        
        return $this->model->with(['presumptive','patient','township','screening_township'])->get();
    }
    
    public function getEach($column = null, $value = null)
    {
        return $this->model->where($column, $value)->first();
    }
    
    public function editInfo($data)
    {
        $model = $this->getEach("id", $data["id"]);

        $insertedData = [
            'date' =>  $data["date"],
            'screening_person' =>  $data["screening_person"],
            'symptom_screening' =>  $data["symptom_screening"],
            'refer'=>$data['refer'],
             'township_id' =>  $data["township_id"],
            'id' =>  $data["id"],
        ];

        $model->update($insertedData);
    }
    
    public function delete($id)
    {
        $model = $this->getEach("id", $id);
                
         try {
                $presumptive = $model->presumptive;
                
                $heActivity = $model->he_activity;
                
                if ($model->type == 2) { //for contact
                    
                    //to reduct in he activity
                    
                        if($model->presumptive)
                        {
                            $isMale = $presumptive->sex == 1;
                            $relationship = $presumptive->relationship;
                            
                            if ($relationship == 1) { // Household
                            
                                $field = $isMale ? 'n_o_household_male' : 'n_o_household_female';
                                
                            } else { // Close contact
                            
                                $field = $isMale ? 'n_o_attendence_male' : 'n_o_attendence_female';
                            } 
                            
                            if ($model->refer == 2) {
                                
                                  $refer_field = $isMale ? 'refer_male' : 'refer_female';
                            }
                            
                            $heActivity->$field > 0 ? $heActivity->$field -= 1:$heActivity->$field=0;
                            
                            if (!empty($refer_field)) {
                                
                                 $heActivity->$refer_field > 0 ? $heActivity->$refer_field -= 1:$heActivity->$refer_field=0;
                                 
                                 $updateData[$refer_field] = $heActivity->$refer_field;
                            }
                           
                            $updateData = [$field => $heActivity->$field];
        
                            $heActivity->update($updateData);
                        }
                    
                    //end of reduct in he activity
                    
                    }
                    
                elseif ($model->type == 1){
                    
                     //to reduct in he activity
                    if($model->presumptive){
                        $isMale = $presumptive->sex == 1;
                        $relationship = $presumptive->relationship;
                        
                        $field = $isMale ? 'n_o_attendence_male' : 'n_o_attendence_female';
                         
                        if ($model->refer == 2) {
                              $refer_field = $isMale ? 'refer_male' : 'refer_female';
                        }
                        
                        $heActivity->$field > 0 ? $heActivity->$field -= 1:$heActivity->$field=0;
                        
                        if (!empty($refer_field)) {
                            
                             $heActivity->$refer_field > 0 ? $heActivity->$refer_field -= 1:$heActivity->$refer_field=0;
                             
                             $updateData[$refer_field] = $heActivity->$refer_field;
                        }
                       
                        $updateData = [$field => $heActivity->$field];
    
                        $heActivity->update($updateData);
                    }
                        
                        
                    //end of reduct in he activity
                    
                    //to delete presumptive patient
                    
                        $presumptive_id= $model->presumptive_id;
                        
                        $presumptive=$presumptive->where('id', $presumptive_id)->first();
                        $presumptive->delete();
                    
                    //end of delete presumptive patient
                    
                }
               
                $model->delete();
                
                return true;
              
         } catch (\Exception $e) {
             
           
            return $e->getMessage();
        }
        
       
    }
    
     public function getExport($data)
    {
        $township_group=$data['township_group_id'];
        $start_date= $data['start_date'];
        $end_date= $data['end_date'];
        
        $data= $this->model->with(['presumptive','patient','screening_township','volunteer',
                                     "township" => function ($query) {
                                            $query->with(["township_group"]);
                                        },
                            ]);
                            
                            // ->where('symptom_screening',2)
                            
        if($township_group==6)
        {
             return $data->whereHas("township",function($query) use ($township_group){
                        $query ->whereIn('township_group_id', [1, 2]);  
                    })->whereBetween('date', [$start_date, $end_date])
                    ->get();
                    
           
        }
        
        return $data->whereHas("township",function($query) use ($township_group){
                        $query->where("township_group_id",$township_group);  
                    })->whereBetween('date', [$start_date, $end_date])
                    ->get();
        
    }
    
}
