<?php

namespace App\Service\Clinic;

class Visit extends CustomClassContainer
{
    function __construct()
    {
        parent::__construct(new \App\Models\ClinicPatientVisit);
    }

    public function withColumn()
    {
        $this->model = $this->model->with([]);
    }

    public function getAll()
    {
        $this->withColumn();
        return $this->model->where("clinic_patient_id", request("clinic_patient_id"))->get();
    }

    public function getEach($column = null, $value = null)
    {
        $this->withColumn();
        return $this->model->where($column, $value)->first();
    }

    public function store()
    {
        $insertedData = [
            "temperature" => request("temperature"),
            "weight" => request("weight"),
            "covid_testing" => request("covid_testing"),
            "follow_up_note" => request("follow_up_note"),
            "remark" => request("remark"),
            "register_date" => request("register_date"),
            "clinic_patient_id" => request("clinic_patient_id")
        ];

        if (request("covid_testing") == 2) {
            $insertedData["covid_testing_date"] = request("covid_testing_date");
            $insertedData["covid_testing_result"] = request("covid_testing_result");
        }

        return $this->model->create($insertedData);
    }

    public function update()
    {
        $model = $this->getEach("id", request("id"));

        $insertedData = [
            "temperature" => request("temperature"),
            "weight" => request("weight"),
            "covid_testing" => request("covid_testing"),
            "follow_up_note" => request("follow_up_note"),
            "remark" => request("remark"),
            "register_date" => request("register_date"),
            "clinic_patient_id" => request("clinic_patient_id")
        ];

        if (request("covid_testing") == 2) {
            $insertedData["covid_testing_date"] = request("covid_testing_date");
            $insertedData["covid_testing_result"] = request("covid_testing_result");
        } else {
            $insertedData["covid_testing_date"] = NULL;
            $insertedData["covid_testing_result"] = NULL;
        }
        $model->update($insertedData);
        return true;
    }

    public function delete($id)
    {
        $model = $this->getEach("id", $id);
        $model->delete();
        return true;
    }
}
