<?php

namespace App\Service\Clinic;

class TreatmentChange extends CustomClassContainer
{
    function __construct()
    {
        parent::__construct(new \App\Models\ClinicPatientTreatment);
    }

    public function withColumn()
    {
        $this->model = $this->model->with([]);
    }

    public function getAll()
    {
        $this->withColumn();
        return $this->model->where("clinic_patient_id", request("clinic_patient_id"))->get();
    }

    public function getEach($column = null, $value = null)
    {
        $this->withColumn();
        return $this->model->where($column, $value)->first();
    }

    public function store()
    {
        $insertedData = [
            "treatment_regimen" => request("treatment_regimen"),
            "date" => request("date"),
            "clinic_patient_id" => request("clinic_patient_id"),
            "tb_code" => request("tb_code"),
            "tb_year" => request("tb_year"),
            "code" => request("code")
        ];
        if (request("treatment_regimen") == 5) {
            $insertedData["name_of_drugs"] = request("name_of_drugs");
        }

        $this->updatePatientCode();

        return $this->model->create($insertedData);
    }

    public function updatePatientCode()
    {
        $patient = \App\Models\ClinicPatient::where("id", request("clinic_patient_id"))->first();
        $patient->tb_code = request("tb_code");
        $patient->tb_year = request("tb_year");
        $patient->code = request("code");
        $patient->update();
    }

    public function update()
    {
        $model = $this->getEach("id", request("id"));

        $insertedData = [
            "treatment_regimen" => request("treatment_regimen"),
            "date" => request("date"),
            "clinic_patient_id" => request("clinic_patient_id"),
            "tb_code" => request("tb_code"),
            "tb_year" => request("tb_year"),
            "code" => request("code")
        ];
        if (request("treatment_regimen") == 5) {
            $insertedData["name_of_drugs"] = request("name_of_drugs");
        }
        $model->update($insertedData);

        $this->updatePatientCode();

        return true;
    }

    public function delete($id)
    {
        $model = $this->getEach("id", $id);
        $model->delete();
        return true;
    }
}
