<?php

namespace App\Service\Clinic;

class PostTreatment extends CustomClassContainer
{
    function __construct()
    {
        parent::__construct(new \App\Models\ClinicPatientPostTreatment);
    }

    public function withColumn()
    {
        $this->model = $this->model->with([]);
    }

    public function getAll()
    {
        $this->withColumn();
        return $this->model->where("clinic_patient_id", request("clinic_patient_id"))->get();
    }

    public function getEach($column = null, $value = null)
    {
        $this->withColumn();
        return $this->model->where($column, $value)->first();
    }

    public function store()
    {
        $insertedData = [
            "month" => request("month"),
            "smear_status" => request("smear_status"),
            "culture_and_dst_status" => request("culture_and_dst_status"),
            "clinic_patient_id" => request("clinic_patient_id")
        ];

        if (request("smear_status") == 2) {
            $insertedData["smear_date"] = request("smear_date");
            $insertedData["smear_result"] = request("smear_result");
        }

        if (request("culture_and_dst_status") == 2) {
            $insertedData["culture_and_dst_date"] = request("culture_and_dst_date");
            $insertedData["culture_and_dst_result"] = request("culture_and_dst_result");
        }

        return $this->model->create($insertedData);
    }

    public function update()
    {
        $model = $this->getEach("id", request("id"));

        $insertedData = [
            "month" => request("month"),
            "smear_status" => request("smear_status"),
            "culture_and_dst_status" => request("culture_and_dst_status"),
            "clinic_patient_id" => request("clinic_patient_id")
        ];

        if (request("smear_status") == 2) {
            $insertedData["smear_date"] = request("smear_date");
            $insertedData["smear_result"] = request("smear_result");
        }

        if (request("culture_and_dst_status") == 2) {
            $insertedData["culture_and_dst_date"] = request("culture_and_dst_date");
            $insertedData["culture_and_dst_result"] = request("culture_and_dst_result");
        }
        $model->update($insertedData);
        return true;
    }

    public function delete($id)
    {
        $model = $this->getEach("id", $id);
        $model->delete();
        return true;
    }
}
