<?php

namespace App\Service\Clinic;

class Patient extends CustomClassContainer
{
    function __construct()
    {
        parent::__construct(new \App\Models\ClinicPatient);
    }

    public function getEach($column = null, $value = null)
    {
        $this->withColumn();
        return $this->model->where($column, $value)->first();
    }


    public function withColumn()
    {
        $this->model = $this->model->with([
            "treatments", "clinic_patient_visits"
        ]);
    }

    public function update()
    {
        $model = $this->getEach("id", request("id"));
        $insertedData = [
            "follow_up_case" => request("follow_up_case"),
            "follow_up_reason" => request("follow_up_reason"),
            "name" => request("name"),
            "age" => request("age"),
            "sex" => request("sex"),
            "phone" => request("phone"),
            "address" => request("address"),
            "registeration_group" => request("registeration_group"),
            "transfer_in_township" => request("transfer_in_township"),
            "treatment_outcome" => request("treatment_outcome"),
            "outcome_date" => request("outcome_date"),
            "comorbid_dm" => request("comorbid_dm"),
            "comorbid_other" => request("comorbid_other"),
            "first_xpert_status" => request("first_xpert_status"),
            "second_xpert_status" => request("second_xpert_status"),
            "dst_status" => request("dst_status"),
            "hiv_status" => request("hiv_status")
        ];

        if (request("follow_up_reason") == 4) {
            $insertedData["otherReason"] = request("otherReason");
        } else {
            $insertedData["otherReason"] = NULL;
        }

        if (request("follow_up_case") == 4) {
            $insertedData["township_name"] = request("township_name");
        } else {
            $insertedData["township_id"] = request("township_id");
        }

        if (request("first_xpert_status") == 2) {
            $insertedData["first_xpert_date"] = request("first_xpert_date");
            $insertedData["first_xpert_result"] = request("first_xpert_result");
        } else {
            $insertedData["first_xpert_date"] = NULL;
            $insertedData["first_xpert_result"] = NULL;
        }

        if (request("second_xpert_status") == 2) {
            $insertedData["second_xpert_date"] = request("second_xpert_date");
            $insertedData["second_xpert_result"] = request("second_xpert_result");
        } else {
            $insertedData["second_xpert_date"] = NULL;
            $insertedData["second_xpert_result"] = NULL;
        }

        if (request("dst_status") == 2) {
            $insertedData["dst_date"] = request("dst_date");
            $insertedData["dst_lab_no"] = request("dst_lab_no");
            $insertedData["dst_result"] = request("dst_result");
            if ($insertedData["dst_result"] == "") {
                $insertedData["susceptible_to"] = request("susceptible_to");
                $insertedData["resistant_to"] = request("resistant_to");
            } else {
                $insertedData["susceptible_to"] = NULL;
                $insertedData["resistant_to"] = NULL;
            }
        } else {
            $insertedData["dst_date"] = NULL;
            $insertedData["dst_lab_no"] = NULL;
            $insertedData["dst_result"] = NULL;
        }

        if (request("hiv_status") == 2) {
            $insertedData["hiv_date"] = request("hiv_date");
            $insertedData["hiv_result"] = request("hiv_result");

            if (request("hiv_result") == 2) {

                $insertedData["cpt_status"] = request("cpt_status");
                $insertedData["art_status"] = request("art_status");;

                if (request("art_status") == 2) {
                    $insertedData["art_date"] = request("art_date");
                } else {
                    $insertedData["art_date"] = NULL;
                }

                if (request("cpt_status") == 2) {
                    $insertedData["cpt_date"] = request("cpt_date");
                } else {
                    $insertedData["cpt_date"] = NULL;
                }
            } else {
                $insertedData["cpt_status"] = NULL;
                $insertedData["art_status"] = NULL;
                $insertedData["cpt_date"] = NULL;
                $insertedData["art_date"] = NULL;
            }
        } else {
            $insertedData["hiv_date"] = NULL;
            $insertedData["hiv_result"] = NULL;
        }

        $model->update($insertedData);
        return true;
    }


    public function store()
    {
        $insertedData = [
            "follow_up_case" => request("follow_up_case"),
            "follow_up_reason" => request("follow_up_reason"),
            "name" => request("name"),
            "age" => request("age"),
            "sex" => request("sex"),
            "phone" => request("phone"),
            "address" => request("address"),
            "tb_code" => request("tb_code"),
            "tb_year" => request("tb_year"),
            "code" => request("code"),
            "registeration_group" => request("registeration_group"),
            "transfer_in_township" => request("transfer_in_township"),
            "treatment_outcome" => request("treatment_outcome"),
            "outcome_date" => request("outcome_date"),
            "comorbid_dm" => request("comorbid_dm"),
            "comorbid_other" => request("comorbid_other"),
            "first_xpert_status" => request("first_xpert_status"),
            "second_xpert_status" => request("second_xpert_status"),
            "dst_status" => request("dst_status"),
            "hiv_status" => request("hiv_status")
        ];

        if (request("follow_up_reason") == 4) {
            $insertedData["otherReason"] = request("otherReason");
        }

        if (request("follow_up_case") == 4) {
            $insertedData["township_name"] = request("township_name");
        } else {
            $insertedData["township_id"] = request("township_id");
        }

        if (request("first_xpert_status") == 2) {
            $insertedData["first_xpert_date"] = request("first_xpert_date");
            $insertedData["first_xpert_result"] = request("first_xpert_result");
        }

        if (request("second_xpert_status") == 2) {
            $insertedData["second_xpert_date"] = request("second_xpert_date");
            $insertedData["second_xpert_result"] = request("second_xpert_result");
        }

        if (request("dst_status") == 2) {
            $insertedData["dst_date"] = request("dst_date");
            $insertedData["dst_lab_no"] = request("dst_lab_no");
            $insertedData["dst_result"] = request("dst_result");
            if ($insertedData["dst_result"] == "") {
                $insertedData["susceptible_to"] = request("susceptible_to");
                $insertedData["resistant_to"] = request("resistant_to");
            }
        }

        if (request("hiv_status") == 2) {
            $insertedData["hiv_date"] = request("hiv_date");
            $insertedData["hiv_result"] = request("hiv_result");
            if (request("hiv_result") == 2) {

                $insertedData["art_status"] = request("art_status");
                $insertedData["cpt_status"] = request("cpt_status");
                if (request("art_status") == 2) {
                    $insertedData["art_date"] = request("art_date");
                }
                if (request("cpt_status") == 2) {
                    $insertedData["cpt_date"] = request("cpt_date");
                }
            }
        }
        $insertedData = $this->model->create($insertedData);

        $treatmentModel = new \App\Models\ClinicPatientTreatment;
        $treatmentModel->treatment_regimen = request("treatment_regimen");
        $treatmentModel->date = request("date");
        $treatmentModel->tb_code = request("tb_code");
        $treatmentModel->tb_year = request("tb_year");
        $treatmentModel->code = request("code");

        if (request("treatment_regimen") == 5) {
            $treatmentModel->name_of_drugs = request("name_of_drugs");
        }
        $treatmentModel->clinic_patient_id = $insertedData->id;
        $treatmentModel->save();

        return $insertedData;
    }

    public function getAll()
    {
        $this->withColumn();
        if (request("search")) {
            $this->model = $this->model->where(function ($query) {
                $query->where("code", request("search"))->orWhere("name", "like", request("search") . "%");
            });
        }

        if (request("start_date") && request("end_date")) {
            $this->model = $this->model->whereHas("clinic_patient_visits", function ($query) {
                $query->whereBetween("register_date", [request("start_date"), request("end_date")]);
            });
        }

        if (request("township_id")) {
            $this->model = $this->model->where("township_id", request("township_id"));
        }


        return $this->model->where("status", 1)->get();
    }

    public function delete($id)
    {
        $model = $this->getEach("id", $id);
        $model->status = 0;
        $model->update();
        return true;
    }
}
