<?php

namespace App\Models;

use Laravel\Passport\HasApiTokens;
use Illuminate\Foundation\Auth\User as Authenticatable;
class Volunteer extends Authenticatable
{
    use HasApiTokens;
    protected $hidden = [
        "created_at", "updated_at"
    ];

    protected $guarded = [];

    public function township()
    {
        return $this->belongsTo(\App\Models\Township::class);
    }

    public function trainings()
    {
        return $this->hasMany(\App\Models\VolunteerTraining::class);
    }

    public function OauthAcessToken()
    {
        return $this->hasMany('App\OauthAccessToken', 'user_id', 'id');
    }

    public function dots_patient()
    {
        return $this->hasMany(\App\Models\DOTSPatient::class);
    }

    public function dots_visit_report(){

        return $this->hasMany(\App\Models\DotsVisitReport::class);
    }
    
    public function dots_visit_date(){
        return $this->hasMany(\App\Models\DotsVisitDate::class);
    }
    
    public function dots_inno_date()
    {
        return $this->hasMany(\App\Models\InnoDotsDate::class, "volunteer_id");
    }

    public function he_activity(){

        return $this->hasMany(\App\Models\HeActivity::class);
    }
}
