<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Township extends Model
{
    protected $hidden = [
        "created_at", "updated_at"
    ];

    protected $casts = [
        'initial' => 'integer',
        'both_mdr_picts' => 'integer'
    ];

    protected $guarded = [];

    public function township_group()
    {
        return $this->belongsTo(\App\Models\TownshipGroup::class);
    }

    public function region()
    {
        return $this->belongsTo(\App\Models\Region::class);
    }

    public function sup_visits(){
        return $this->belongsToMany(\App\Models\SupVisit::class,"sup_visit_townships");
    }
    
    public function cis(){
        return $this->belongsToMany(\App\Models\Ci::class);
    }
}
