<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SupervisionVisitActivity extends Model
{
    use HasFactory;

    protected $guarded = [];
    
    protected $appends = ["comments"];
    
    protected $casts = [
        'patient_id' => 'integer',
        'month' => 'integer',
        'year' => 'integer',
        'dots_type' => 'integer',
        'volunteer_id' => 'integer',
        'supervision_type' => 'integer',
    ];

    public function township()
    {
        return $this->belongsTo(\App\Models\Township::class);
    }

    public function patient()
    {
        return $this->belongsTo(\App\Models\Patient::class);
    }

    public function volunteer()
    {
        return $this->belongsTo(\App\Models\Volunteer::class);
    }

    public function getRadioValueListAttribute()
    {
        return json_decode($this->attributes["radio_value_list"]);
    }
    
     public function getCommentsAttribute(){
        $comments=\App\Models\Comment::where(["item_id"=>$this->attributes["id"],"item_type"=>"SUPERVISION"])->get();
        return $comments;
    }
    
}
