<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SupVisit extends Model
{
    protected $casts = [
        'type_of_visit' => 'integer',
    ];
    protected $guarded = [];

    public function getAttachmentAttribute()
    {
        if ($this->attributes["attachment"])
            return asset('storage/supvisits/attachments/'. $this->attributes['attachment']);
    }

    public function visitor()
    {
        return $this->belongsTo(\App\Models\Member::class, "visitor_id");
    }

    public function townships()
    {
        return $this->belongsToMany(\App\Models\AllTownship::class, "sup_visit_townships");
    }

    public function co_visitors()
    {
        return $this->belongsToMany(\App\Models\Member::class, "sup_visit_members", "sup_visit_id", "member_id");
    }
}

