<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PresumptiveDiagnosis extends Model
{
    use HasFactory;

    protected $casts = [
        'times' => 'integer','hiv_status' => 'integer',  
        'sputum_status' => 'integer','cxr_status' => 'integer',  
        'gene_xpert_status' => 'integer',  'culture_status' => 'integer',  
        'dst_status' => 'integer',  'other_investigation_status' => 'integer',  
        'referral_from_id'=>'integer',
        'referral_type_id'=>'integer',
        'conclusion'=>'integer',
    ];
    
     public function presumptive()
    {
        return $this->belongsTo(\App\Models\Presumptive::class);
    }

    public function symptons()
    {
        return $this->belongsToMany(\App\Models\Sympton::class);
    }

    public function risk_factors()
    {
        return $this->belongsToMany(\App\Models\RiskFactor::class);
    }

    public function hiv_result_name()
    {
        return $this->belongsTo(\App\Models\Hiv::class, "hiv_result");
    }

    public function sputum_result_name()
    {
        return $this->belongsTo(\App\Models\Sputum::class, "sputum_result");
    }

    public function cxr_result_name()
    {
        return $this->belongsTo(\App\Models\Cxr::class, "cxr_result");
    }

    public function gene_xpert_result_name()
    {
        return $this->belongsTo(\App\Models\GeneXpert::class, "gene_xpert_result");
    }

    public function culture_result_name()
    {
        return $this->belongsTo(\App\Models\Culture::class, "culture_result");
    }

    public function dst_result_name()
    {
        return $this->belongsTo(\App\Models\DST::class, "dst_result");
    }
    
    // public function getDstResultAttribute($value)
    // {
    //     return json_decode($this->attributes["dst_result"]);
    // }

    public function conclusion_name()
    {
        return $this->belongsTo(\App\Models\ConclusionTreatment::class, "conclusion");
    }

    public function refer_from_name()
    {
        return $this->belongsTo(\App\Models\ReferralFrom::class, "referral_from_id");
    }

    public function refer_type_name()
    {
        return $this->belongsTo(\App\Models\ReferralType::class, "referral_type_id");
    }
}
