<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Presumptive extends Model
{
    use HasFactory;

    protected $guarded = [];

    protected $hidden = [
        "created_at", "updated_at"
    ];

    protected $casts = [
        'case_found_at' => 'integer','index_case_no' => 'integer',  
        'index_case_year' => 'integer','relationship' => 'integer',  
        'confirm' => 'integer', 'gender'=>'integer' 
    ];


    public function patient()
    {
        return $this->belongsTo(\App\Models\Patient::class);
    }

    public function case_found_at_name()
    {
        return $this->belongsTo(\App\Models\CaseFoundAt::class, "case_found_at");
    }

    public function township()
    {
        return $this->belongsTo(\App\Models\Township::class);
    }

    public function volunteer()
    {
        return $this->belongsTo(\App\Models\Volunteer::class);
    }

    public function diagonsis()
    {
        return $this->hasMany(\App\Models\PresumptiveDiagnosis::class,"presumptive_id");
    }
    
     public function cis()
    {
        return $this->hasMany(\App\Models\Ci::class,"presumptive_id");
    }
    
    public function existing_presumptive_data()
    {
       return $this->belongsTo(\App\Models\Presumptive::class,"existing_presumptive_id");
    }
    
     public function supportingTownship()
    {
        return $this->belongsTo(\App\Models\Township::class,"supporting_township");
    }

}
