<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PreEnrollSupport extends Model
{
    use HasFactory;

    protected $appends = ["signature", "type_info"];

    protected $casts = ['support' => 'integer', 'nominated' => 'integer', 'support_month' => 'integer', 'support_year' => 'integer'];

    protected $hidden = [];

    protected $guarded = [];


    public function patient()
    {
        return $this->belongsTo(\App\Models\Patient::class);
    }

    public function delagated_person()
    {
        return $this->belongsTo(\App\Models\DelagatedPerson::class);
    }

    public function getSignatureAttribute()
    {
        if ($this->attributes["support"] == 2) {
            return asset('storage/patients/pre_enrolls/supports/' . $this->attributes['signature']);
        }
    }

    public function getTypeInfoAttribute()
    {
        return "PREENROLL";
    }
}
