<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Patient extends Model
{
    use HasFactory;

    protected $hidden = [
        "created_at", "updated_at"
    ];

    protected $appends = ["reg_unique_code", "is_dots_patient", "is_filled_enroll", "is_auto_nominated","diff_finished_change","comments"];

    protected $guarded = [];

    protected $casts = [
        'lab_result' => 'integer',
        'treatment_finish' => 'integer',
         'mdrtb_reg_initial' => 'integer',
        'final_outcome' => 'integer', 'gene_result' => 'integer',
        'type_of_patient' => 'integer', 'type_of_tb' => 'integer',
        't_in' => 'integer',
        't_in_type' => 'integer',
        't_in_township_id' => 'integer',
        't_in_type' => 'integer',
        'outside_tsp' => 'integer', 'outside_tsp' => 'integer',
        'hiv_status' => 'integer', 'art_rx' => 'integer', 'cpt_rx' => 'integer', 'hiv_result' => 'integer',
        'lpa_result' => 'integer', 'mdrtb_reg_no' => 'integer', 'mdrtb_reg_year' => 'integer',
        "outside_tsp_name" => 'integer',
        'cxr_result' => 'integer',
        'culture_result' => 'integer',
    ];

    public function getRegUniqueCodeAttribute()
    {
        $code = null;

        if ($this->attributes["mdrtb_reg_no"] < 10) $code = "0000";
        else if ($this->attributes["mdrtb_reg_no"] < 100) $code = "000";
        else if ($this->attributes["mdrtb_reg_no"] < 1000) $code = "00";
        else if ($this->attributes["mdrtb_reg_no"] < 10000) $code = "0";


        $code .= $this->attributes["mdrtb_reg_no"];

        $model = \App\Models\Township::where("id", $this->attributes["township_id"])->first();
        $initial = $model->short_code;

        return $initial . "_" . $this->attributes["mdrtb_reg_year"] . "_" . $code;
    }

    public function getIsDotsPatientAttribute()
    {
        if (\App\Models\DOTSPatient::where("patient_id", $this->attributes["id"])->where("status",1)->first()) {
            return true;
        } else {
            return false;
        }
    }

    public function getIsFilledEnrollAttribute()
    {

        $filled = \App\Models\EnrollSupport::where("patient_id", $this->attributes["id"]);

        if (request("nominated_month") && request("nominated_year")) {
            $filled = $filled->where("support_month", request("nominated_month"))->where("support_year", request("nominated_year"));
        } else {
            $current = \Carbon\Carbon::now();
            $filled = $filled->where("support_month", $current->month)->where("support_year", $current->year);
        }

        $filled = $filled->first();

        if ($filled) {
            return true;
        } else {
            return false;
        }
    }

    public function getIsAutoNominatedAttribute()
    {
        if (!$this->attributes["finished_date"]) {
            return true;
        }
        $current = \Carbon\Carbon::now();
        $finishedDate = \Carbon\Carbon::parse($this->attributes["finished_date"]);
        if ($current < $finishedDate) return true;
        else return false;
    }

    public function getDiffFinishedChangeAttribute(){
        if (!$this->attributes["change_finished_date"]){
            return null;
        }
        
        $current = \Carbon\Carbon::now();
        $changedDate = \Carbon\Carbon::parse($this->attributes["change_finished_date"]);
        $diff_in_days = $current->diffInDays($changedDate);
        return $diff_in_days;

    }

    public function township()
    {
        return $this->belongsTo(\App\Models\Township::class);
    }

    public function comorbid_diseases()
    {
        return $this->hasMany(\App\Models\PatientComorbidDisease::class, "patient_id");
    }

    public function mdrtbRegiments()
    {
        return $this->hasMany(\App\Models\PatientMdrtbRegiment::class, "patient_id");
    }
    
    
    public function family_members()
    {
        return $this->hasMany(\App\Models\Presumptive::class, "patient_id");
    }
    
     public function cis()
    {
        return $this->hasMany(\App\Models\Ci::class, "patient_id");
    }


    public function dots_patient()
    {
        return $this->hasMany(\App\Models\DOTSPatient::class, "patient_id");
    }
    
    //  public function homevisit()
    // {
    //     return $this->hasOne(\App\Models\HomeVisitActivity::class, "patient_id");
    // }

    public function pre_enroll_supports()
    {
        return $this->hasMany(\App\Models\PreEnrollSupport::class, "patient_id");
    }

    public function enroll_supports()
    {
        return $this->hasMany(\App\Models\EnrollSupport::class, "patient_id");
    }

    public function transfer_in_township(){
        return $this->belongsTo(\App\Models\Township::class,"t_in_township_id");
    }

    public function scopeStillNominated($query)
    {
        return $query->whereRaw('is_auto_nominated=true');
    }
    
      public function getCommentsAttribute(){
        $comments=\App\Models\Comment::where(["item_id"=>$this->attributes["id"],"item_type"=>"PATIENT"])->get();
        return $comments;
    }
    
    
}
