<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InnoDotsDate extends Model
{
    use HasFactory;
    protected $fillable = [
        'dots_patient_id',
        'volunteer_id',
        'date','type','status','work_type','actions','minor_side_effects','major_side_effects','video_link','signature','high_side_effect'
    ];
    
    public function dots_patient()
    {
        return $this->belongsTo("App\Models\DOTSPatient","dots_patient_id");
    }
    
    public function volunteer()
    {
        return $this->belongsTo("\App\Models\Volunteer","volunteer_id");
    }
}
