<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HomeVisitActivity extends Model
{
    use HasFactory;

    protected $casts = [
        'patient_id' => 'integer',
        // 'month' => 'integer',
        // 'year' => 'integer',
        'type' => 'integer',
    ];
    
    protected $appends = ["comments"];

    protected $guarded = [];

    public function township()
    {
        return $this->belongsTo(\App\Models\Township::class);
    }

    public function patient()
    {
        return $this->belongsTo(\App\Models\Patient::class);
    }
    
   
    public function getInfectionControlAttribute()
    {
       //$decodedValue = optional(json_decode($this->attributes["infection_control"]))->get();
      
        if(isset($this->attributes["infection_control"])){
            return json_decode($this->attributes["infection_control"]);
        }
        return [];
      
      
    }

    public function getModificationsAttribute()
    {   
        // $decodedValue = optional(json_decode($this->attributes["modifications"]))->get();
        
        if(isset($this->attributes["modifications"])){
            return json_decode($this->attributes["modifications"]);
        }
        return [];
    
    }

    public function getSeChecklistAttribute()
    {
        //$decodedValue = optional(json_decode($this->attributes["se_checklist"]))->get();
        
       if(isset($this->attributes["se_checklist"])){
            return json_decode($this->attributes["se_checklist"]);
        }
        return [];
    }
    
    public function getCommentsAttribute(){
        $comments=\App\Models\Comment::where(["item_id"=>$this->attributes["id"],"item_type"=>"HOMEVISIT"])->get();
        return $comments;
    }
    
}
