<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HeActivity extends Model
{
    use HasFactory;

    protected $casts = [
        'volunteer_id' => 'integer',
        'n_o_attendence_male'=>'integer',
        'n_o_attendence_female'=>'integer',
        'n_o_household_male'=>'integer',
        'n_o_household_female'=>'integer',
        'n_o_closecontact_male'=>'integer',
        'n_o_closecontact_female'=>'integer',
    ];
    
     protected $appends = ["comments"];

    protected $guarded = [];

    public function township()
    {
        return $this->belongsTo(\App\Models\Township::class);
    }

    public function volunteer()
    {
        return $this->belongsTo("\App\Models\Volunteer","volunteer_id");
    }
    
    public function ci()
    {
        return $this->hasMany(\App\Models\Ci::class,"he_activity_id");
    }
    
     public function symptoms()
    {
        return $this->hasMany(\App\Models\HeActivitySymptom::class,"he_activity_id");
    }
    
    
    
    public function getCommentsAttribute(){
        $comments=\App\Models\Comment::where(["item_id"=>$this->attributes["id"],"item_type"=>"HE"])->get();
        return $comments;
    }
    
}   
