<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EnrollSupport extends Model
{
    use HasFactory;

    protected $appends = ["signature","type_info"];

    protected $hidden = [
        
    ];

    protected $guarded = [];


    public function patient()
    {
        return $this->belongsTo(\App\Models\Patient::class);
    }

    public function getTypeInfoAttribute()
    {
        return "ENROLL";
    }

    public function getSignatureAttribute()
    {
        if ($this->attributes["support"] == 2) {
            if ($this->attributes["type"] == 1)
                return asset('storage/patients/enrolls/supports/' . $this->attributes['signature']);
        }
    }

    public function delagated_person()
    {
        return $this->belongsTo(\App\Models\DelagatedPerson::class);
    }
}
