<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DOTSPatient extends Model
{
    use HasFactory;
    protected $guarded = [];

    protected $casts = [
        'gender' => 'integer',
        'tb_type_id' => 'integer',
        'status' => 'integer',
    ];

    protected $appends = ["reported_this_month", "reported_status"];

    public function patient()
    {
        return $this->belongsTo(\App\Models\Patient::class);
    }

    public function dots_main_acitivty()
    {
        return $this->hasMany(\App\Models\DotsMainActivity::class, "dots_patient_id");
    }

    public function dots_visit_report()
    {
        return $this->hasMany(\App\Models\DotsVisitReport::class, "dots_patient_id");
    }
    
    public function dots_visit_date()
    {
        return $this->hasMany(\App\Models\DotsVisitDate::class, "dots_patient_id");
    }
    
     public function dots_inno_date()
    {
        return $this->hasMany(\App\Models\InnoDotsDate::class, "dots_patient_id");
    }


     public function volunteer()
    {
        return $this->belongsTo("\App\Models\Volunteer","volunteer_id");
    }

    public function getReportedThisMonthAttribute()
    {
        if (isset($this->attributes["dots_app_status"])) {
            if ($this->attributes["dots_app_status"] == 1) {
                if (\App\Models\DotsVisitReport::where(
                    [
                        "month" => \Carbon\Carbon::now()->month,
                        "year" => \Carbon\Carbon::now()->year,
                        "dots_patient_id" => $this->attributes["id"],
                    ]
                )
                    ->first()
                ) {
                    return true;
                } else {
                    return false;
                }
            } else if ($this->attributes["dots_app_status"] == 2) {
                if (\App\Models\DotsVisitDate::whereMonth("date", \Carbon\Carbon::now()->month)
                    ->whereYear("date", \Carbon\Carbon::now()->year)
                    ->where("status", 1)
                    ->where("dots_patient_id", $this->attributes["id"])->first()
                ) {
                    return true;
                } else {
                    return false;
                }
            }
        }
    }

    public function getReportedStatusAttribute()
    {
        if (isset($this->attributes["dots_app_status"])) {
            if ($this->attributes["dots_app_status"] == 1) {
                if ($this->attributes["dots_enddate"] != null) {
                    $finishStatus = \App\Models\DotsVisitReport::where("dots_patient_id", $this->attributes["id"])->orderBy("id", "desc")->first();
                    if ($finishStatus) {
                        if ($finishStatus->status == 1) {
                            return "Stop";
                        }
                    }
                } else {
                    return "On-going";
                }
            }
        }
    }
}
