<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CounselingActivity extends Model
{
    use HasFactory;

    protected $guarded = [];
    
     protected $appends = ["comments"];

    public function township()
    {
        return $this->belongsTo(\App\Models\Township::class);
    }

    public function patient()
    {
        return $this->belongsTo(\App\Models\Patient::class);
    }

    public function topics()
    {
        return $this->hasMany(\App\Models\CounselingActivityTopic::class,"counseling_activity_id");
    }
    
      public function getCommentsAttribute(){
        $comments=\App\Models\Comment::where(["item_id"=>$this->attributes["id"],"item_type"=>"COUNSELING"])->get();
        return $comments;
    }
}
