<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ClinicPatient extends Model
{

    protected $guarded = [];

    protected $casts = [
        'follow_up_reason' => 'integer',
        'follow_up_case' => 'integer',
        'township_id' => 'integer',
        'tb_code' => 'integer',
        'tb_year' => 'integer',
        'sex' => 'integer',
        'registeration_group' => 'integer',
        'first_xpert_status' => 'integer',
        'first_xpert_result' => 'integer',
        'second_xpert_status' => 'integer',
        'second_xpert_result' => 'integer',
        'dst_status' => 'integer',
        'dst_result' => 'integer',
        'hiv_status' => 'integer',
        'hiv_result' => 'integer',
        'treatment_outcome' => 'integer',
        'comorbid_dm' => 'integer',
        'art_status'=>'integer',
        'cpt_status'=>'integer',

    ];

    public function treatments()
    {
        return $this->hasMany(\App\Models\ClinicPatientTreatment::class, "clinic_patient_id");
    }

    public function clinic_patient_visits()
    {
        return $this->hasMany(\App\Models\ClinicPatientVisit::class, "clinic_patient_id");
    }
}
