<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Ci extends Model
{
    use HasFactory;
     protected $guarded = [];
     
    protected $hidden = [
        "created_at", "updated_at"
    ];
    
     public function presumptive()
    {
        return $this->belongsTo(\App\Models\Presumptive::class);
    }

    public function patient()
    {
        return $this->belongsTo(\App\Models\Patient::class);
    }
    
    public function township()
    {
        return $this->belongsTo(\App\Models\Township::class);
    }
    
    public function volunteer()
    {
        return $this->belongsTo(\App\Models\Volunteer::class);
    }
    
    public function screening_township()
    {
        return $this->belongsTo(\App\Models\Township::class,"screening_township_id");
    }
    
     public function he_activity()
    {
        return $this->belongsTo(\App\Models\HeActivity::class,"he_activity_id");
    }
    
}
