<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class SendMail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($data)
    {
        $this->data = $data; 
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
      
        return $this->view('mails.side_effect_alert')
                    ->subject('Referred By Volunteer from DOTS App') 
                    ->with([
                        'patient_name' => $this->data['pt_name'],
                        'volunteer_name' => $this->data['vol_name'],
                        'high_side_effect'=>$this->data['side_effect'],
                         'low_side_effect'=>$this->data['low_side_effect'],
                        'date'=>$this->data['date']
                    ]);
                    // low_side_effect
    }
}
